package cn.quantgroup.customer.entity;

import lombok.*;

import javax.persistence.*;

@Entity
@Table(name = "transaction_receipt_record")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
public class TransactionReceiptRecord {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Integer userId;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "serial_no")
    private String serialNo;

    @Column(name = "import_status")
    private Integer importStatus = 0;

    @Column(name = "export_status")
    private Integer exportStatus = 0;

    @Column(name = "order_no")
    private String orderNo;

    @Column(name = "batch_no")
    private Integer batchNo =0;

    @Column(name = "sign_status")
    private Integer signStatus = 0;

    @Column(name = "export_batch_no")
    private Integer exportBatchNo = 0;

    public TransactionReceiptRecord() {

    }
}
