package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.exception.BusinessException;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.service.IRepayService;
import cn.quantgroup.customer.service.IUserService;
import cn.quantgroup.customer.service.IXyqbService;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.vo.UserSysResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service("repayService")
public class RepayServiceImpl implements IRepayService {

    private final IUserService userService;
    private final UserSdkImpl userSdk;
    private final IXyqbService xyqbService;

    @Autowired
    public RepayServiceImpl(IUserService userService, UserSdkImpl userSdk, IXyqbService xyqbService) {
        this.userService = userService;
        this.userSdk = userSdk;
        this.xyqbService = xyqbService;
    }

    @Override
    public String findRepayOrders(RepayOrderQuery repayOrderQuery) {
        String phoneNo = repayOrderQuery.getPhoneNo();
        String idNo = repayOrderQuery.getIdNo();
        if (StringUtils.isEmpty(phoneNo) && StringUtils.isEmpty(idNo)) {
            throw new BusinessException(ErrorCodeEnum.PARAM_ERROR);
        }
        if (StringUtils.isEmpty(phoneNo)) {
            String uuid = userService.findUuidByIdNo(idNo);
            UserSysResult<XUser> userUserSysResult = userSdk.getService().findUserByUuid(uuid);
            if (!userUserSysResult.isSuccess()) {
                throw new BusinessException(ErrorCodeEnum.RETURN_ERROR);
            }
            Long userId = userUserSysResult.getData().getId();
            repayOrderQuery.setUserId(userId);
        }

        return xyqbService.findRepayOrders(repayOrderQuery);
    }
}
