package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.service.IXyqbService;
import cn.quantgroup.customer.service.http.IHttpService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("xyqbService")
public class XyqbServiceImpl implements IXyqbService {

    @Value("${api.http}")
    private String xyqbSysUrl;

    private final IHttpService httpService;

    @Autowired
    public XyqbServiceImpl(IHttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public String findRepayOrders(RepayOrderQuery repayOrderQuery) {
        String phoneNo = repayOrderQuery.getPhoneNo();
        Long userId = repayOrderQuery.getUserId();
        String url = xyqbSysUrl + "/ex/repayment/repay_orders";
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotEmpty(phoneNo)) {
            param.put("phoneNo", phoneNo);
        }
        if (Objects.nonNull(userId)) {
            param.put("userId", userId);
        }
        String response = httpService.get(url, param);
        log.info("[xyqb][query repay orders ] param:{},请求业务系统返回值:{}", param, response);
        return response;
    }
}
