package cn.quantgroup.customer.rest;
import cn.quantgroup.customer.rest.param.transactionreceipt.TransactionReceiptRecordQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.transaction.*;
import cn.quantgroup.customer.service.ITransactionReceiptRecordService;
import cn.quantgroup.customer.service.http.IHttpService;
import cn.quantgroup.customer.util.FileToZip;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.Synchronized;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/transactionReceiptRecord")
public class TransactionReceiptRecordRest {

    @Autowired
    private ITransactionReceiptRecordService transactionReceiptRecordService;
    @Autowired
    private IHttpService httpService;

    /**
     * 根据筛选条件进行查询
     * @param query
     * @return
     */
    @RequestMapping("/orderQuery/query_page")
    @ResponseBody
    public JsonResult<Page<TransactionReceiptRecordVO>> queryPage(@RequestBody TransactionReceiptRecordQuery query) {
        if (query.getPageNo()== null || query.getPageNo() < 1) {
            log.error("[TransactionReceiptRecordRest_queryPage]查询参数pageNumber错误，pageNo={}", query.getPageNo());
            return JsonResult.buildErrorStateResult("查询参数pageNo错误");
        }
        Integer pageNo = query.getPageNo() - 1;
        query.setPageNo(pageNo);
        if (query.getPageSize() == null) {
            log.error("[workOrderRest_queryPage]查询参数pageSize错误，pageSize={}", query.getPageSize());
            return JsonResult.buildErrorStateResult("查询参数pageSize错误");
        }
        return transactionReceiptRecordService.findRecordsByQuery(query);
    }
    /**
     * 导入excel表格
     */
    @RequestMapping("/orderQuery/importTransactionReceiptRecord")
    @ResponseBody
    public JsonResult importTransactionReceiptRecord(@RequestParam("file") MultipartFile file) {
        try{
            return transactionReceiptRecordService.importTransactionReceiptRecord(file);
        }catch(Exception e){
            transactionReceiptRecordService.deleteRedis("importTransactionReceiptRecord");
            return JsonResult.buildErrorStateResult(e.getMessage());
        }
    }
    /**
     * 导出压缩包之前先校验
     */
    @RequestMapping("/orderQuery/checkCanExport")
    public JsonResult checkCanExport() {
        return transactionReceiptRecordService.checkCanExport();
    }

    /**
     * 后台更新交易凭证状态
     * @return
     */
    @RequestMapping("/orderQuery/updateTransactionRecordsStatus")
    @ResponseBody
    public JsonResult updateTransactionRecordsStatus() {
        return transactionReceiptRecordService.updateTransactionRecordsStatus();
    }

    //导出压缩包
    @RequestMapping("/orderQuery/exportTransactionZipFile")
    @ResponseBody
    public JsonResult exportTransactionZipFile(HttpServletRequest request, HttpServletResponse response) throws Exception{
        try{
            return transactionReceiptRecordService.exportZipFile(request,response);
        }catch(Exception e){
            transactionReceiptRecordService.deleteRedis("exportZipFile");
            return JsonResult.buildErrorStateResult("导出文件出现错误");
        }

    }

}
