package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.service.http.IHttpService;
import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

import static cn.quantgroup.customer.constant.Constant.LOGOUT_SUCCESS;

@Slf4j
@RestController
@RequestMapping("/test")
public class TestRest {

    @Autowired
    private IHttpService httpService;

    @GetMapping(value = "/auth")
    public JsonResult testAuth() {
        return JsonResult.buildSuccessResult(LOGOUT_SUCCESS, null);
    }


    @RequestMapping(value = "/audit", method = RequestMethod.PUT)
    public JsonResult audit(@RequestBody AuditParam auditParam) {
        return JsonResult.buildSuccessResult("success", auditParam);
    }

    @RequestMapping(value = "/put_audit")
    public JsonResult putAudit() {
        //String url = "http://127.0.0.1:7067/test/audit";
        String url = "";
        Map<String, String> header = Maps.newHashMap();
        header.put("Content-type", "application/json");

        Map<String, String> auditParam = Maps.newHashMap();
        auditParam.put("applyStatus", "true");
        auditParam.put("applyStatusReason", "success");
        auditParam.put("id", "rx12308866");

        JsonResult result = httpService.put(url, header, auditParam, JsonResult.class);
        return result;
    }

    @RequestMapping(value = "/modify/{id}/feedback", method = RequestMethod.PUT)
    public JsonResult feedback(@PathVariable String id) {
        return JsonResult.buildSuccessResult("success", id);
    }


    @Setter
    @Getter
    static class AuditParam {
        private boolean applyStatus;
        private String applyStatusReason;
        private String id;
    }

}
