package cn.quantgroup.cashloanflowboss.spi.paycenter.entity;

import cn.quantgroup.cashloanflowboss.spi.paycenter.model.CardType;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * 卡号效验表
 * @author wudi
 */
@Data
@Entity
@Table(name = "card_check_record")
public class CardCheckRecordEntity {


	/**
	 * id
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Long id;


	/**
	 * 卡号
	 */
	@Column(name = "card_no")
	private String cardNo;

	/**
	 * 银行编码
	 */
	@Column(name = "bank_code")
	private String bankCode;

	/**
	 * 银行名称
	 */
	@Column(name = "bank_name")
	private String bankName;

	/**
	 * 支行编码
	 */
	@Column(name = "branch_no")
	private String branchNo;

	/**
	 * 支行名称
	 */
	@Column(name = "branch_name")
	private String branchName;

	/**
	 * 省份
	 */
	@Column(name = "province")
	private String province;

	/**
	 * 城市
	 */
	@Column(name = "city")
	private String city;

	@Column(name = "card_type")
	private CardType cardType;

	/**
	 * 是否可用
	 */
	@Column(name = "is_active")
	private Boolean isActive = Boolean.TRUE;

	/**
	 * createdAt
	 */
	@Column(name = "created_at")
	private Timestamp createdAt;

	/**
	 * updatedAt
	 */
	@Column(name = "updated_at")
	private Timestamp updatedAt;


	@PrePersist
	public void prePersist() {
		Timestamp timestamp = new Timestamp(System.currentTimeMillis());
		createdAt = timestamp;
		updatedAt = timestamp;
	}

	@PreUpdate
	public void preUpdate() {
		updatedAt = new Timestamp(System.currentTimeMillis());
	}
}
