package cn.quantgroup.cashloanflowboss.api.oneclickdata.controller;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.*;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.utils.RandomlyGeneratedParameters;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Logger;

/**
 * Created by shang on 2019/12/3.
 */
@Slf4j
@RestController
@RequestMapping("/oneclickdate")
public class OneClickDataController {

    @Autowired
    private OneClickDataOperateService oneClickDataOperateService;
    @Autowired
    private OneClickDataQueueOperateService oneClickDataQueueOperateService;
    @Autowired
    private RepaymentPlatService repaymentPlatService;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CashWithdrawalService cashWithdrawalService;
    @Autowired
    private LoanOperationService loanOperationService;
    @Autowired
    private OneClickDataOperateJobService oneClickDataOperateJobService;
    @Autowired
    CommMethod commMethod;
    private OneClickModel oneClickModelNew;

    @PostMapping("/v1/type")
    public Result oneClickDataOperate(@RequestBody @Valid OneClickModel oneClickModel) throws Exception {
        log.info("实体类oneClickModel={}",oneClickModel);
        if (oneClickModel.getType().isEmpty()) {
            log.info("打印一下oneClickModel.getType()={}",oneClickModel.getType());
            return Result.buildFail("操作类型必填");
        } else {
             oneClickModelNew=setDefaultValue(oneClickModel);
            String defaultChannel="1";
            if(defaultChannel.equals(oneClickModelNew.getChannel())){
                return Result.buildFail("暂不支持Channel=1的渠道");
            }
             String fundID=oneClickModelNew.getFundID();
            if(CommonType.PRODUCTID540.getDesc().equals(fundID) || CommonType.PRODUCTID610.getDesc().equals(fundID) || CommonType.PRODUCTID650.getDesc().equals(fundID) || CommonType.PRODUCTID670.getDesc().equals(fundID)){
                return Result.buildFail("暂不支持惠金所业务");
            }
            log.info("打印最新的oneClickModelNew={}", oneClickModelNew);
            if (oneClickModel.getType().equals(String.valueOf(TypeEnum.APPLY.getCode()))) {
                return onekeyApply(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.CASHWITHDRAWAL.getCode()))) {
                return oneKeyCashWithdrawal(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.CREDITSUCCESS.getCode())) || oneClickModel.getType().equals(String.valueOf(TypeEnum.CREDITFAIL.getCode()))) {
                return oneKeyCreditSuccessOrFail(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.LOANSUCCESS.getCode())) || oneClickModel.getType().equals(String.valueOf(TypeEnum.LOANFAIL.getCode()))) {
                return oneKeyLoanSuccessOrFail(oneClickModelNew);
            } else {
                return Result.buildFail("没有匹配到操作类型Type");
            }
        }


    }

    @PostMapping("/v1/select")
    public Result oneClickDataSelect(@RequestBody @Valid OneClickSelectModel oneClickSelectModel ){
        log.info("打印一下oneClickSelectModel={}", oneClickSelectModel);
       return Result.buildSuccess(oneClickDataOperateService.findOneClickSelectModelByCriteriaQueryPage(oneClickSelectModel));
    }

    @GetMapping("/v1/cashwith")
    public Result oneClickDataMq(@RequestParam (value = "queueMsg") String queueMsg){
        log.info("打印一下queueMsg={}",queueMsg);
        oneClickDataQueueOperateService.getCreditNotifyIsSucess(queueMsg);
        return Result.buildSuccess("ok");
    }



    @GetMapping("/v1/selecttype")
    public Result oneClickDataSelectTypeList(){
        List<OneClickTypeModel> oneClickTypeModelList= commMethod.getTypeList();
        return Result.buildSuccess(oneClickTypeModelList);
    }

    @GetMapping("/v1/channelCode")
    public Result oneClickDataChannelCodeList(){
        List<OneClickTypeModel> oneClickTypeModelList= commMethod.getTypeList();
        return Result.buildSuccess(commMethod);
    }


    @PostMapping("/v1/repayment")
    public Result oneClickDataRepayment(@RequestParam (value = "loadId") String loadId){
        log.info("打印一下loadId={}", loadId);
        OneClickData oneClickData=oneClickDataRespository.findByLoanId(loadId);

        return repaymentPlatService.whetherHaveRepayment0rdersList(oneClickData);
    }


    @PostMapping("/v1/cashwithdrawal")
    public Result oneClickDataCashWithdrawal(@RequestParam (value = "orderNo") String orderNo){
        log.info("打印一下orderNo={}", orderNo);
        OneClickData oneClickData=oneClickDataRespository.findByOrderNo(orderNo);
        return cashWithdrawalService.applyLoan(oneClickData);
    }
    public Result onlyCashWithdrawal(String orderNo){
        log.info("打印一下orderNo={}", orderNo);
        OneClickData oneClickData=oneClickDataRespository.findByOrderNo(orderNo);
        return cashWithdrawalService.applyLoan(oneClickData);
    }

    @GetMapping("/v1/selectprogress")
    public Result oneClickDataSelectProgress(@RequestParam (value = "userId") String userId,@RequestParam (value = "businessType") String businessType){
        log.info("打印一下参数userId={},businessType={}",userId,businessType);
        LoanApplicationHistory loanApplicationHistory= loanOperationService.selectLoanId(Long.valueOf(userId), Integer.parseInt(businessType));

        return Result.buildSuccess(loanApplicationHistory, "ok");
    }



    @PostMapping("/v1/cashwithdrawalandapplyloan")
    public Result oneClickDataClickDataCashWithdrawalAndApplyLoan(@RequestParam (value = "orderNo") String orderNo){
        log.info("打印一下orderNo={}", orderNo);
        OneClickData oneClickData=oneClickDataRespository.findByOrderNo(orderNo);
        return oneClickDataQueueOperateService.commonFundAssifnSucc(oneClickData);
    }


    @PostMapping("/v1/applyLendingNotify")
    public Result oneClickDataClickDataApplyLendingNotify(@RequestParam (value = "orderNo") String orderNo){
        log.info("打印一下orderNo={}", orderNo);
        OneClickData oneClickData=oneClickDataRespository.findByOrderNo(orderNo);
        return Result.buildSuccess(oneClickDataQueueOperateService.applyLendingNotifyOnly(oneClickData), "返回放款结果");
    }


    @GetMapping("/v1/selectcount")
    public Result selectCount(@RequestParam (value = "fundId") String fundId){
       Integer num= loanOperationService.queryLendingRecordSumCount(Long.parseLong(fundId));
        return Result.buildSuccess(num,"查看待放款数量");
    }




    @GetMapping("/v1/selectmoneycount")
    public Result selectMoneyCount(@RequestParam (value = "fundId") String fundId){
        BigDecimal num= loanOperationService.queryLendingRecordAmountMountSumCount(Long.parseLong(fundId));
        return Result.buildSuccess(num,"查看待放款金额数量");
    }

    @GetMapping("/v1/fundjob")
    public Result oneClickDataFundJob(){
        oneClickDataOperateJobService.excuteFundJob();
        return Result.buildSuccess("ok");
    }



    @GetMapping("/v1/creditjob")
    public Result oneClickDataCreditJob(){
        oneClickDataOperateJobService.excuteSelectCreditStatusJob();
        return Result.buildSuccess("ok");
    }


    public Result onekeyApply(OneClickModel oneClickModel) {
        if(oneClickModel.getChannel().equals(ChannelEnum.One.getCode())){
            return  oneClickDataOperateService.h5OnekeyApply(oneClickModel);

        }else {
            return  oneClickDataOperateService.onekeyApply(oneClickModel);

        }

    }

    public Result oneKeyCashWithdrawal(OneClickModel oneClickModel) throws Exception{


        return  oneClickDataOperateService.oneKeyCashWithdrawal(oneClickModel);
    }

    public Result oneKeyCreditSuccessOrFail(OneClickModel oneClickModel) throws Exception {

        return oneClickDataOperateService.oneKeyCreditSuccessOrFail(oneClickModel);
    }

    public Result oneKeyLoanSuccessOrFail(OneClickModel oneClickModel) throws Exception {
        return  oneClickDataOperateService.oneKeyLoanSuccessOrFail(oneClickModel);
    }

    public OneClickModel setDefaultValue(OneClickModel oneClickModel){


        if (StringUtils.isBlank(oneClickModel.getPhone())){
          String randPhone;
          randPhone = RandomlyGeneratedParameters.getTel();
          oneClickModel.setPhone(randPhone.toString());
        }

        if(StringUtils.isBlank(oneClickModel.getChannel())){
          oneClickModel.setChannel("1");
        }

        if(StringUtils.isBlank(oneClickModel.getAmount()) ){
          oneClickModel.setAmount("10000");
        }

        if(StringUtils.isBlank(oneClickModel.getFundID())){
          oneClickModel.setFundID("710");
        }

        if(StringUtils.isBlank(oneClickModel.getProductId())){
          oneClickModel.setProductId("1");
        }

        if(StringUtils.isBlank(oneClickModel.getTermNo())){
          oneClickModel.setTermNo("12");
        }
        log.info("打印重新设置的oneClickModel={}",oneClickModel);
        return oneClickModel;
    }


    public static void main(String[] arg) throws Exception {

    }
}


