package cn.quantgroup.cashloanflowboss.api.user.model;

import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserRank;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.component.validator.constraints.NotEmpty;
import lombok.Data;

/**
 * @author Wang Xiangwei
 * @version 2020/3/2
 */
@Data
public class UserModelVo {

    private Long id;

    /**
     * 用户名
     */
    @NotEmpty(message = "用户名不能为空")
    private String username;

    /**
     * 昵称
     */
    @NotEmpty(message = "用户昵称不能为空")
    private String nickname;

    /**
     * 密码
     */
    private String password;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 用户级别
     */
    @NotEmpty(message = "用户级别不能为空")
    private UserRank rank;

    private Long roleId;

    /**
     * 用户状态
     */
    @NotEmpty(message = "用户活跃状态不能为空")
    private UserStatus status;
}
