package cn.quantgroup.cashloanflowboss.api.customer.controller;

import cn.quantgroup.cashloanflowboss.api.customer.entity.CustomerInfo;
import cn.quantgroup.cashloanflowboss.api.customer.service.ICustomerService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author Wang Xiangwei
 * @version 2020/7/9
 */
@RestController
@RequestMapping("/customer")
public class CustomerController {

    @Autowired
    private ICustomerService customerService;

    @GetMapping("/apply/info")
    public Result<CustomerInfo> getCustomerInfo(String phoneNo,String channelOrderNo){
        CustomerInfo customerInfo = customerService.getCustomerInfo(phoneNo, channelOrderNo);
        if(Objects.isNull(customerInfo)){
            return Result.buildFail("查询出错");
        }
        return Result.buildSuccess(customerInfo);
    }
}
