package cn.quantgroup.cashloanflowboss.api.order.service;

import cn.quantgroup.cashloanflowboss.api.order.model.*;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRecordVoModel;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * function:
 * date: 2019/9/16
 *
 * @author: suntao
 */
public interface OrderService {
    Page<OrderVo> orderList(Long channelId, String channelOrderNo, String applyNo, Long loanId, Integer pageNumber, Integer pageSize);

    /**
     * 审批功能
     * @param approveVo
     * @return 《是否成功 ， msg》
     */
    Tuple<Boolean, String> approveOpt(ApproveVo approveVo);

    /**
     *
     * @param channelOrderNumber
     * @return 《是否成功 ， msg》
     */
    @Transactional(rollbackFor = Exception.class)
    Tuple<Boolean, String> secondAudit(String channelOrderNumber);

    @Transactional(rollbackFor = Exception.class)
    Tuple<Boolean, String> lending(LendingFormModel lendingFormModel);

    HistoryOrderStatusVoModel getOrderHistoryStatus(String channelOrderNumber);

    Tuple<Boolean,String> cancelPreLoan(String channelOrderNumber);

    Tuple<Boolean,String> cancelAfterLoan(String channelOrderNumber);

    List<CallbackRecordVoModel> getOrderCallbackRecordList(String channelOrderNumber);

    RepaymentPlansResultModel findRepaymentPlan(String channelOrderNumber, Long loanId);

    void loadSecondAuditJob();

    /**
     * 结清
     * @param channelOrderNumber
     * @return
     */
    Tuple<Boolean,String> settle(String channelOrderNumber);
}
