package cn.quantgroup.cashloanflowboss.core.exception;

import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.core.dictionary.Status;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * 自定义系统异常
 * <p>
 * Created by WeiWei on 2017/5/2.
 */
@Slf4j
@Data
public class ApplicationException extends RuntimeException {

    /**
     * 异常状态码
     */
    private int code;

    /**
     * 异常描述信息
     */
    private String message;

    /**
     * 异常状态对象
     */
    private Status status;

    public ApplicationException() {
        this(ApplicationStatus.FAILURE);
    }

    public ApplicationException(String message) {
        this(ApplicationStatus.FAILURE, message);
    }

    public ApplicationException(Throwable throwable) {
        this(ApplicationStatus.FAILURE, throwable, ApplicationStatus.FAILURE.getMessage());
    }

    public ApplicationException(Status status) {
        this(status, status.getMessage());
    }

    public ApplicationException(Status status, String message) {
        this(status, null, message);
    }

    public ApplicationException(Status status, Throwable throwable, String message) {

        super(Objects.nonNull(message) ? message : Objects.nonNull(status) ? status.getMessage() : Objects.nonNull(throwable) ? throwable.getMessage() : "", throwable);

        this.status = Objects.nonNull(status) ? status : ApplicationStatus.FAILURE;

        this.code = this.status.getCode();
        this.message = (Objects.nonNull(message) ? message : Objects.nonNull(status) ? status.getMessage() : Objects.nonNull(throwable) ? throwable.getMessage() : "");

        log.error(Objects.nonNull(throwable) ? throwable.getMessage() : message, Objects.nonNull(throwable) ? throwable : this);

    }

}
