package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

/**
 * Created by WeiWei on 2019/8/13.
 */
@XYQBDataSource
@Repository
public interface ContractRepository extends CrudRepository<Contract, Long> {

    /**
     * 更新合同状态
     *
     * @param userId
     * @param status
     * @return
     */
    @Query("update Contract set generate_status = :status where userId = :userId")
    boolean updateContractStatus(Long userId, Integer status);

}
