package cn.quantgroup.cashloanflowboss.spi.jolyne;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.WaitingFundingCorpOperatePeople;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * function:
 * date: 2019/9/20
 *
 * @author: suntao
 */
@Slf4j
@Service
public class JolyneServiceImpl implements JolyneService {

    @Autowired
    private XYQBCenterService xyqbCenterService;
    @Autowired
    private JolyneCenter jolyneCenter;

    @Value("${NAMESPACE}")
    private String namespace;


    @Override
    public String executeXYQBSQL(String jsonData) {
        return jolyneCenter.executeXYQBSQL(jsonData);
    }

    @Override
    public void fetchDataLoanJob() {
        jolyneCenter.fetchDataLoanJob(namespace);
    }

    @Override
    public void loanDataJob() {
        jolyneCenter.loanDataJob(namespace);
    }

    @Async
    @Override
    public String delayUpdateWaitingXyqbSql(Long loanId, Long delayTime) {


        WaitingFundingCorpOperatePeople waitingFundingCorpOperatePeople = xyqbCenterService.findWaitingFundingCorpOperatePeopleByLoanId(loanId);

        int i = 0;

        while (waitingFundingCorpOperatePeople == null) {
            try {
                Thread.sleep(delayTime);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            waitingFundingCorpOperatePeople = xyqbCenterService.findWaitingFundingCorpOperatePeopleByLoanId(loanId);

            if (++ i > 10000) {
                return "fail";
            }
        }

        if (waitingFundingCorpOperatePeople.getCreatedAt().getTime() > (System.currentTimeMillis() - 5 * 60 * 1000)) {
            // 更新待放款时间(5分钟之前)
            ArrayList<String> updateWaitingFundingCorpOperatePeople = Lists.newArrayList();
            updateWaitingFundingCorpOperatePeople.add("update waiting_funding_corp_operate_people set created_at = DATE_SUB(created_at, interval 5 minute) where loan_application_history_id = " + loanId + ";");
            return jolyneCenter.executeXYQBSQL(JolyneUtil.getJolneSql(updateWaitingFundingCorpOperatePeople));
        }

        fetchDataLoanJob();
        loanDataJob();

        return "success";
    }
}
