package cn.quantgroup.cashloanflowboss.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by conglin.liu on 2017/8/3.
 */
@Slf4j
public class DateUtil {

    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);

    public final static String DATE_FORMAT_1 = "yyyy-MM-dd HH:mm:ss";
    public final static String yyyyMMdd_HHmm = "yyyyMMdd_HHmm";
    public final static String YYYYMMDD = "yyyyMMdd";
    public final static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public final static String YYYYMMDD_HHMMSS = "yyyyMMdd HHmmss";
    public final static String YYYY_MM_DD = "yyyy-MM-dd";

    public final static DateTimeFormatter dateTimeFormatter_yyyy_MM_dd = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public final static DateTimeFormatter dateTimeFormatter_yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");

    public final static String date_suffix = "235959";

    /**
     * 获得时间戳（10位，精确到秒）
     * @return
     */
    public static String getTenTimestamp() {
        return String.valueOf(new Timestamp(System.currentTimeMillis()).getTime() / 1000);
    }


    /**
     * 字符串(秒) 转为 Timestamp(10位)
     * @param tsStr  2017-06-06 12:00:00  -> 1496721600
     * @return
     */
    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    /**
     * 字符串(秒) 转为 Timestamp(10位)
     * @param tsStr  2017-06-06 12:00:00  -> 1496721600
     * @return
     */
    public static Date stringToDate(String tsStr) {
        Date date = new Date();
        try {
            date = new Date(Long.valueOf(tsStr));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    /**
     * 数值 毫秒值 转时间
     * @param times 时间的毫秒值
     * @return
     */
    public static Date getByLongTimes(Long times) {
        Date date = null;
        try {
            date = new Date(times);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }


    /**
     * 使用参数Format格式化Date成字符串
     */
    public static String format(Date date, String pattern) {
        try {
            return date == null ? "" : new SimpleDateFormat(pattern).format(date);
        } catch (Exception e) {
            log.error("[exception]date transfer error,date={},pattern={}",date,pattern);
            return "";
        }
    }

    /**
     * 将yyyy-MM-dd 转成 yyyyMMdd+时分秒
     * @param deadline
     * @return yyyyMMddHHmmss
     */
    public static String getDeadline(String deadline) {
        try {
            if (StringUtils.isNotBlank(deadline)) {
                String date = deadline.replaceAll("-", "").replaceAll("/", "").substring(0, 8);
                return date + date_suffix;
            } else {
                return LocalDateTime.now().format(dateTimeFormatter_yyyyMMdd) + date_suffix;
            }
        } catch (Exception e) {
            return LocalDateTime.now().format(dateTimeFormatter_yyyyMMdd) + date_suffix;
        }
    }

    /**
     * 将yyyy-MM-dd 转成 yyyyMMdd+时分秒
     * @param deadline
     * @return yyyyMMddHHmmss
     */
    public static String getDeadline(Date deadline) {
        try {
            if (deadline != null) {
                String date = format(deadline, YYYYMMDD);
                return date + date_suffix;
            } else {
                return LocalDateTime.now().format(dateTimeFormatter_yyyyMMdd) + date_suffix;
            }
        } catch (Exception e) {
            return LocalDateTime.now().format(dateTimeFormatter_yyyyMMdd) + date_suffix;
        }
    }

    /**
     * 时间字符串 转换成时间
     * @param dateStr 时间字符串
     * @param parsePatterns 时间字符串 格式
     * @return
     */
    public static Date dateStr2Date(String dateStr, String parsePatterns) {
        try {
            return DateUtils.parseDate(dateStr, parsePatterns);
        } catch (ParseException e) {
            logger.error("时间转换出错,deadline={},parsePatterns={}", dateStr, parsePatterns, e);
            return new Date();
        }
    }


    /**
     * 获取当前时间
     * @return Timestamp
     */
    public static Timestamp getCurrentTimestamp(){
        return new Timestamp(System.currentTimeMillis());
    }

    /**
     * 把时间字符串，源格式转换为 目标格式输出
     * @param dateStr 时间字符串
     * @param dateFormatSource : （source）格式
     * @param dateFormatTarget （target）格式
     * @return
     */
    public static String parse(String dateStr, String dateFormatSource, String dateFormatTarget) {
        String dateFormat;
        try {
            dateFormat = format(dateStr2Date(dateStr, dateFormatSource), dateFormatTarget);
            if (StringUtils.isEmpty(dateFormat)) {
                logger.error("时间为空,dateStr={},parsePatterns={}", dateStr, dateFormatSource + "2" + dateFormatTarget);
                dateFormat = format(new Date(), dateFormatTarget);
            }
        } catch (Exception e) {
            logger.error("时间转换出错,dateStr={},parsePatterns={}", dateStr, dateFormatSource + "2" + dateFormatTarget, e);
            dateFormat = format(new Date(), dateFormatTarget);
        }
        return dateFormat;
    }

    public static Date monthLater() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.MONTH, 1);
        return new Date(calendar.getTime().getTime());
    }

    public static Date dayLater() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, 1);
        return new Date(calendar.getTime().getTime());
    }

    /**
     * 根据时间 获取10位 时间戳
     * @param updated
     * @return
     */
    public static Long get10LongTimeFromDate(Date updated) {
        if (updated == null) {
            return System.currentTimeMillis() / 1000;
        } else {
            return updated.getTime() / 1000;
        }
    }

    /**
     * 判断当前时间是否在[startTime, endTime]区间，注意时间格式要一致
     *
     * @param nowTime 当前时间
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return true 在区间，false:不在区间
     * @author suntao
     */
    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime()
                || nowTime.getTime() == endTime.getTime()) {
            return true;
        }

        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);

        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);

        Calendar end = Calendar.getInstance();
        end.setTime(endTime);

        if (date.after(begin) && date.before(end)) {
            return true;
        } else {
            return false;
        }
    }
}
