package cn.quantgroup.cashloanflowboss.api.user.service;

import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.model.UserDetailInfo;
import cn.quantgroup.cashloanflowboss.api.user.model.UserInfoModel;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import org.springframework.data.domain.Page;

/**
 * function:
 * date: 2019/9/19
 *
 * @author: suntao
 */
public interface UserService {
    boolean createUser(String username, String password);

    User getUser(String username);

    Page<User> getUsers(Integer pageNumber, Integer pageSize);

    boolean enableUser(String id);

    boolean disableUser(String id);

    User updateUser(User user);

    Boolean removeUser(String id);

    UserDetailInfo getUserDetailInfo();

    User saveUserInfo(UserInfoModel user);

    Tuple<Boolean,String> cleanUserActiveOrder(String mobile);
}
