package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;


import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FinanceProduct;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author PoppyWong
 * @since 2019/11/18.
 */
@XYQBDataSource
@Repository
public interface IFinanceProductRepository extends JpaRepository<FinanceProduct, Long> {

    @Query(value = "select * from finance_product where fund_corp_id = ?1 and is_active = 1", nativeQuery = true)
    List<FinanceProduct> findByFundCorpId(Long fundCorpId);

    @Query(value = "select * from finance_product where id = ?2 and fund_corp_id = ?1 and is_active = 1", nativeQuery = true)
    FinanceProduct findByFundCorpIdAndProductId(Long fundCorpId, Long productId);

}
