package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import bsh.StringUtil;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.utils.AESUtil;
import cn.quantgroup.cashloanflowboss.utils.ChineseIDCardNumberGenerator;
import cn.quantgroup.cashloanflowboss.utils.GetEncryptContentAndMd5;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class ApplyLoanServiceImpl implements ApplyLoanService {
    String idNo =  ChineseIDCardNumberGenerator.generate();
    String orderNo="testOrderNo_0001";

    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    OneClickDataRespository oneClickDataRespository;
    @Autowired
    CLFCenterServiceImpl clfCenterService;

    @Autowired
    PhoneInfoService phoneInfoService;

    OneClickOV oneClickOV;
    ClfChannelConfiguration clfChannelConfiguration;
    public static String md5Keywy = "qEAxMJBv";
    public static String aesKeywy = "sxD8KO79EDK0N0AJ";
    Result oneClickReslut=null;

    @Override
    public Result applyLoan(OneClickModel oneClickModel){
        JSONObject result;
        oneClickReslut=new Result();
        oneClickOV=new OneClickOV();
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickModel.getChannel().trim()));
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();
        if(oneClickModel.getChannel().equals(ChannelEnum.ZHANGHZONG.getCode())){
            result= zhangZhongApply(oneClickModel,md5Keywy,aesKeywy);

        }else if(oneClickModel.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            result= shiGuangFenQiApply();
        }else if(oneClickModel.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
            result= xiaoJMApply();
        }else if(oneClickModel.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
            result= guoMeiApply();
        }else if(oneClickModel.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
            result= weiDianApply();
        }else{
            result= defautApply();
        }

        String getDecryption = AESUtil.decryptAfterBase64Decode(result.get("context").toString(), aesKeywy);
        log.info("解密的getDecryption的结果={}" + getDecryption);

        JSONObject getDecryptionResult = (JSONObject) JSONObject.parse(getDecryption);
        log.info("打印一下getDecryptionResult={}",getDecryptionResult.get("bizData"));
        JSONObject bizData= (JSONObject) JSONObject.parse(getDecryptionResult.get("bizData").toString());
        log.info("bizData={}",bizData);
        String code=bizData.get("code").toString();
        String businessCode=bizData.get("businessCode").toString();
        String msg=bizData.get("msg").toString();
        log.info("msg={}",msg);
        if(code.equals("0") && businessCode.equals("0000")){
            //申请的数据插入数据库 one_click_data
            OneClickData oneClickData=new OneClickData();
            oneClickData.setPhone(oneClickModel.getPhone());
            oneClickData.setChannel(GetEncryptContentAndMd5.getChannelName(oneClickModel.getChannel()));
            oneClickData.setChannelCode(oneClickModel.getChannel());
            oneClickData.setChannelOrderNo(orderNo);

            //通过手机号获取用户信息
            XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
            oneClickData.setUserId(xUser.getId().toString());
            oneClickData.setUuid(xUser.getUuid());

            oneClickData.setType(Integer.parseInt(oneClickModel.getType()));
            oneClickData.setCreditStatus(CreditStatusEnum.DEFAULT);
            oneClickData.setLoanStatus(LoanStatusEnum.DEFAULT.getCode());
            oneClickData.setFundCorpId(oneClickModel.getFundID());
            oneClickData.setAmount(new BigDecimal(oneClickModel.getAmount()));
            oneClickData.setTermNo(Integer.parseInt(oneClickModel.getTermNo()));
            // 把提现的数据存放到表one_click_data中
            oneClickDataRespository.save(oneClickData);


            oneClickOV.setCreditMessage(CreditStatusEnum.DEFAULT.getDesc());
            oneClickOV.setLoanMessage(LoanStatusEnum.DEFAULT.getDesc());
            oneClickReslut.setData(oneClickOV);
            oneClickReslut.setCode(ApplicationStatus.SUCCESS.getCode());
            oneClickReslut.setMessage(msg);
            return oneClickReslut;
        }else{
            oneClickReslut.setMessage(msg);
            oneClickReslut.setData(oneClickOV);
            oneClickReslut.setCode(ApplicationStatus.FAILURE.getCode());
            return oneClickReslut;
        }

    }

    @Override
    public JSONObject zhangZhongApply(OneClickModel oneClickModel,String md5Keywy,String aesKeywy) {
        String url = qapiHttp+"/ex/api/v2/applyLoan/ZHANGZHONG";
        //测试
//        String url = "http://qapi-arch.liangkebang.net"+"/ex/api/v2/applyLoan/ZHANGZHONG";

        orderNo="ZZ_"+oneClickModel.getPhone()+"_"+System.currentTimeMillis();
        String name = "简介";
        String channelUserId = "ZZ_"+ oneClickModel.getPhone();

        Map<String, Object> paras =new HashMap<String, Object>();
        paras.put("address", "湖北省恩施州利川团堡");
        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("amount","11110.00");
        para2.put("period","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put( "organization","1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0,para7);
        paras.put("creditList", listPara1);

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content", encryptContent);
        log.info("查看结果content={}", content_map);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);
        return result;


    }

    @Override
    public JSONObject shiGuangFenQiApply() {
        return null;
    }

    @Override
    public JSONObject xiaoJMApply() {
        return null;
    }

    @Override
    public JSONObject guoMeiApply() {
        return null;
    }

    @Override
    public JSONObject weiDianApply() {
        return null;
    }

    @Override
    public JSONObject defautApply() {
        return null;
    }




    public static void main(String[] arg){
//        OneClickModel oneClickModel2 = new OneClickModel();
//        oneClickModel2.setType("1");
//        oneClickModel2.setChannel("159858");
//        oneClickModel2.setTermNo("12");
//        oneClickModel2.setPhone("17800000009");
//        oneClickModel2.setAmount("10000");
//        oneClickModel2.setFundID("710");
//       ApplyLoanServiceImpl  applyLoanService=new ApplyLoanServiceImpl();
//        applyLoanService.applyLoan(oneClickModel2);
        System.out.print("打印时间"+System.currentTimeMillis());

    }

}
