package cn.quantgroup.cashloanflowboss.api.user.entity;

import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.core.persistence.Primary;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Data
@Entity
@Table(name = "user")
public class User extends Primary {

    /**
     * 用户名
     */
    @Column(name = "username")
    private String username;

    /**
     * 密码
     */
    @Column(name = "password")
    private String password;

    /**
     * 用户状态
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "status")
    private UserStatus status;

    /**
     * 最后登录时间
     */
    @Column(name = "last_login_time")
    private Date lastLoginTime;

}
