package cn.quantgroup.cashloanflowboss.spi.jolyne;

import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.jolyne.model.JolyneDB;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.WaitingFundingCorpOperatePeople;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;

/**
 * function:
 * date: 2019/9/20
 *
 * @author: suntao
 */
@Slf4j
@Service
public class JolyneServiceImpl implements JolyneService {

    @Autowired
    private XYQBCenterService xyqbCenterService;
    @Autowired
    private JolyneCenter jolyneCenter;




    @Override
    public String executeSQL(JolyneDB jolyneDB, String jsonData) {
        return jolyneCenter.executeSQL(jolyneDB.getDbName(), jsonData);
    }


    @Override
    public void reloadJob(String jobName) {
        jolyneCenter.reloadJob(jobName);
    }

    @Async("commonAsyncExecutor")
    @Override
    public String delayUpdateWaitingXyqbSql(Long loanId, Long delayTime) {


        WaitingFundingCorpOperatePeople waitingFundingCorpOperatePeople;
        LoanApplicationHistory loanApplicationHistory;

        int i = 0;

        while (true) {
            try {
                Thread.sleep(delayTime);
            } catch (InterruptedException e) {
                log.error("Thread.sleep error");
            }

            loanApplicationHistory = xyqbCenterService.findLoanApplicationHistoryById(loanId);
            if (loanApplicationHistory != null && LoanProgress.WAITING_FUND.equals(loanApplicationHistory.getProgress())) {
                // loan 状态是20 查询 waitingFundingCorpOperatePeople
                waitingFundingCorpOperatePeople = xyqbCenterService.findWaitingFundingCorpOperatePeopleByLoanId(loanId);
                break;
            }
            if (++ i > 20000) {
                return "fail";
            }
        }

        long fiveAgo = System.currentTimeMillis() - 5 * 60 * 1000;
        if (waitingFundingCorpOperatePeople.getCreatedAt().getTime() > fiveAgo) {
            // 更新待放款时间(5分钟之前)
            waitingFundingCorpOperatePeople.setCreatedAt(new Timestamp(fiveAgo));
            xyqbCenterService.saveWaitingFundingCorpOperatePeople(waitingFundingCorpOperatePeople);
        }

        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {
            log.error("Thread.sleep error");
        }
        reloadJob("cn.qg.clotho.job.FetchDataLoanJob");


        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {
            log.error("Thread.sleep error");
        }
        reloadJob("cn.qg.clotho.job.LoanDataJob");

        return "success";
    }

    @Override
    public String delayExecuteSql(JolyneDB jolyneDB, String jsonData, Long delayTime) {
        return null;
    }
}
