package cn.quantgroup.cashloanflowboss.spi.paycenter.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

/**
 * Created by shang on 2020/2/20.
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup"}, entityManagerFactoryRef = "guBeiEntityManager", transactionManagerRef = "guBeiTransactionManager", includeFilters = @ComponentScan.Filter(GuBeiDataSource.class))
public class GuBeiBataSourceConfiguration {
    @Value("${data.payment.url}")
    private String jdbcUrl;

    @Value("${data.payment.password}")
    private String password;

    @Value("${data.payment.username}")
    private String user;

    private String uniquename = "paymentDS";

    @Value("${data.payment.pool-size}")
    private Integer poolSize;

    @Bean(name = "GuBeiDataSource")
    @ConfigurationProperties(prefix = "data.payment")
    public DataSource createDataSource() {
        DruidDataSource source = DruidDataSourceBuilder.create().build();
        source.setMaxActive(200);
        source.setInitialSize(10);
        source.setMinIdle(10);
        source.setMaxWait(500000);
        source.setTimeBetweenEvictionRunsMillis(60000);
        source.setMinEvictableIdleTimeMillis(300000);
        source.setValidationQuery("SELECT 'x'");
        source.setTestWhileIdle(true);
        source.setTestOnBorrow(false);
        source.setTestOnReturn(false);
        source.setPoolPreparedStatements(Boolean.FALSE);
        return source;
    }


    @Bean(name = "guBeiEntityManager")
    public LocalContainerEntityManagerFactoryBean entityManager(EntityManagerFactoryBuilder builder) {

        return builder.dataSource(createDataSource())
                .packages("cn.quantgroup.cashloanflowboss.spi.paycenter.entity")
                .persistenceUnit(uniquename)
                .build();
    }

    @Bean(name = "guBeiTransactionManager")
    public PlatformTransactionManager transactionManager(@Qualifier("guBeiEntityManager") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }


}
