package cn.quantgroup.cashloanflowboss.spi.gyxd.entity;

import cn.quantgroup.cashloanflowboss.spi.gyxd.model.LoanProgress;

import cn.quantgroup.cashloanflowboss.spi.gyxd.model.ProductType;
import cn.quantgroup.cashloanflowboss.spi.gyxd.model.ReportProgress;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * Created by admin on 2016/8/23.
 */
@Data
@Entity
@Table(name = "loan_application_manifest_history")
public class LoanApplicationManifestHistory implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "loan_id")
    private String loanId; //申请单编号

    @Column(name = "loan_user_id")
    private Long loanUserId;

    @Column(name = "channel_id")
    private Integer channelId;

    @Column(name = "bank_card_id")
    private Long bankCardId;

    /**
     * 贷款进度
     *
     * @see LoanProgress
     */
    @Column(name = "loan_progress")
    private LoanProgress loanProgress; //

    /**
     * 上报金融局进度:0－没资格录入 1-贷款信息待录入  2-贷款信息文件已生成 3－贷款信息上传成功(已标记成功) 4-贷款信息上传失败(标记失败，可以重新导出)
     */
    @Column(name = "reported_progress")
    private ReportProgress reportedProgress;

    @Column(name = "amount")
    private BigDecimal amount; //贷款金额

    @Column(name = "term")
    private Integer term; //还款月数

    @Column(name = "purpose")
    private String purpose; //贷款用途

    @Column(name = "protocol_number")
    private String protocolNumber; //协议号

    @Column(name = "service_fee_per_term")
    private BigDecimal serviceFeePerTerm; //每期服务费

    @Column(name = "total_repayment_amount")
    private BigDecimal totalRepaymentAmount; //总还款额

    @Column(name = "monthly_repayment")
    private BigDecimal monthlyRepayment; //月还款额

    @Column(name = "annual_interest_rate")
    private BigDecimal annualInterestRate; //年利率

    @Column(name = "principal_and_interest_per_term")
    private BigDecimal principalAndInterestPerTerm; //每期用户本息

    @Column(name = "total_principal_and_interest")
    private BigDecimal totalPrincipalAndInterest; //总共用户本息

    @Column(name = "loan_received_at")
    private Timestamp loanReceivedAt; //到账时间

    @Column(name = "loan_paid_at")
    private Timestamp loanPaidAt; //放款时间

    @Column(name = "transaction_status")
    private Integer transactionStatus; //交易状态

    @Column(name = "remark")
    private String remark; //备注

    @Column(name = "payment_notification_url")
    private String paymentNotificationUrl;

    @Column(name = "notify_at")
    private Timestamp notifyAt; //回盘时间

    @Column(name = "created_at")
    private Timestamp createdAt; //创建时间

    @Column(name = "updated_at")
    private Timestamp updatedAt; //更新时间

    @Column(name = "credit_assignment")
    private Integer creditAssignment; // 债转方

    @Column(name = "sign_status")
    private Integer signStatus;//签约状态,0:未签约,1:签约中,2:签约成功

    @Column(name = "loan_status")
    private Integer loanStatus;//放款状态,0:未放款,1:放款中,2:放款成功,3:放款失败

    @Column(name = "recall_status")
    private Integer recallStatus;//回盘状态,0:未回盘,1:已回盘

    @Column(name = "debt_status")
    private Integer debtStatus;//按订单债转状态,0:未债转,1:债转中,2:已债转

    @Column(name = "repay_status")
    private Integer repayStatus;//还款状态,0:未还款,1:部分还款完成, 2:全部还款完成

    @Column(name = "distribute_fund_id")
    private Long distributeFundId;//进件资金方id

    @Column(name = "credit_assigned_at")
    private Timestamp creditAssignedAt; //债转完成时间

    //产品类型
    @Column(name = "product_type")
    private ProductType productType;

}
