package cn.quantgroup.cashloanflowboss.spi.xyqb.model;

import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 查询订单状态 model
 * Created with suntao on 2018/12/26
 */
@Data
@NoArgsConstructor
public class OrderStatusQueryModel {
    /** APPROVE 时 非空,元 */
    private String drawTryAmount;
    /** APPROVE 时 非空,元 */
    private String drawTryTerm;

    private ClfOrderMapping orderMapping;

    /** 可以为空 */
    private QueryType queryType;

    public OrderStatusQueryModel(ClfOrderMapping orderMapping) {
        this.orderMapping = orderMapping;
    }

    public enum QueryType {
        APPROVE("审批状态查询"),
        WITHDRAW("提现状态查询，贷前提现"),
        CANCEL_LOAN("取消借款"),
        CANCEL_AFTER_LOAN("取消借款,贷后,退款"),
        PAY("放款状态查询"),
        ALL_REPAID("结清状态查询");

        private String desc;
        public String getDesc(){
            return this.desc;
        }
        QueryType(String desc) {
            this.desc = desc;
        }
    }
}
