package cn.quantgroup.cashloanflowboss.api.user.repository;

import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;

/**
 * Created by WeiWei on 2019/7/22.
 */
@CashLoanFlowBossDataSource
@Repository
public interface UserRepository extends PagingAndSortingRepository<User, String> {

    /**
     * 获取用户
     *
     * @param username 用户名
     * @return
     */
    User getUserByUsername(String username);

    /**
     * 获取用户列表（分页）
     *
     * @param pageable 分页
     * @return
     */
    Page<User> findAllBy(Pageable pageable);

}
