package cn.quantgroup.cashloanflowboss.api.channel.service;
import java.sql.Timestamp;
import java.util.*;

import cn.quantgroup.cashloanflowboss.api.channel.entity.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfAddModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfBaseModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelListModel;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfCallbackConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.api.channel.repository.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderCallBack;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfCallbackConfigurationRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfChannelConfigurationRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderCallbackRepository;
import cn.quantgroup.cashloanflowboss.utils.IgnorePropertiesUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */

@Service
public class ChannelConfService {

    @Autowired
    private ChannelConfRepository channelConfRepository;
    @Autowired
    private ClfChannelConfigurationRepository clfChannelConfigurationRepository;
    @Autowired
    private ClfCallbackConfigurationRepository clfCallbackConfigurationRepository;
    @Autowired
    private ClfOrderCallbackRepository clfOrderCallbackRepository;



    public Page<ChannelListModel> getChannelInfo(Integer pageNumber, Integer pageSize, Long channelId) {

        Page<ClfChannelConfiguration> page = this.clfChannelConfigurationRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        Page<ChannelListModel> channelListModelPage = page.map(it -> {
            ChannelListModel channelListModel = new ChannelListModel();
            channelListModel.setChannelId(it.getRegisteredFrom());
            channelListModel.setChannelName(it.getChannelName());
            channelListModel.setChannelCode(it.getChannelCode());
            // TODO 
            channelListModel.setBizType(null);
            channelListModel.setCreatedAt(it.getCreatedAt());
            return channelListModel;
        });

        return channelListModelPage;
    }


    public ChannelConfVo getChannelConf(Long channelId) {
        ChannelConf channelConf = channelConfRepository.getByChannelId(channelId);
        return ChannelConfUtil.channelConfConvertVOModel(channelConf);
    }


    public Boolean editChannelConfInfo(ChannelConfVo confVo) {
        ChannelConfBaseModel basicInfo = confVo.getBasicInfo();
        ChannelConfAddModel addInfo = confVo.getAddInfo();

        ChannelConf channelConf = ChannelConfUtil.voModelConfConvertChannelConf(confVo);

        ChannelConf channelConfExsit = channelConfRepository.getByChannelId(basicInfo.getChannelId());

        // cash-loan-flow-boss 库
        if (channelConfExsit == null) {
            // 新保存
            channelConf.setCreateTime(new Date());
            channelConfRepository.save(channelConf);
        } else {
            // 更新数据库 数据
            BeanUtils.copyProperties(channelConf, channelConfExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConf));
            channelConfExsit.setUpdateTime(new Date());
            channelConfRepository.save(channelConfExsit);
        }

        // clf 库
        ClfChannelConfiguration channelConfiguration = ChannelConfUtil.convert2ClfChannelConfiguration(basicInfo);
        List<ClfOrderCallBack> clfOrderCallBackList = ChannelConfUtil.convert2ClfOrderCallback(basicInfo.getChannelId(), addInfo);
        ClfChannelConfiguration channelConfigurationExsit = clfChannelConfigurationRepository.findByRegisteredFrom(basicInfo.getChannelId());
        if (channelConfigurationExsit == null) {
            // 新保存
            channelConfiguration.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            clfChannelConfigurationRepository.save(channelConfiguration);

            ClfCallbackConfiguration clfCallbackConfiguration = ChannelConfUtil.convert2ClfCallbackConfiguration(basicInfo);
            clfCallbackConfigurationRepository.save(clfCallbackConfiguration);

            clfOrderCallbackRepository.save(clfOrderCallBackList);
        } else {
            // update
            BeanUtils.copyProperties(channelConfiguration, channelConfigurationExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConfiguration));
            clfChannelConfigurationRepository.save(channelConfigurationExsit);

            // 更新OrderCallBack
            for (ClfOrderCallBack clfOrderCallBack : clfOrderCallBackList) {
                ClfOrderCallBack orderCallBackExsit = clfOrderCallbackRepository.findByCallbackStatusAndRegisteredFrom(clfOrderCallBack.getCallbackStatus().name(), clfOrderCallBack.getRegisteredFrom());
                if (orderCallBackExsit != null) {
                    clfOrderCallBack.setId(orderCallBackExsit.getId());
                }
            }
            clfOrderCallbackRepository.save(clfOrderCallBackList);
        }
        return true;
    }
}
