package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.implnew;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ResposeResultEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.FundsAllocationplanService;
import cn.quantgroup.cashloanflowboss.utils.CoverDate;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/20.
 */
@Slf4j
@Service
public class FundsAllocationplanServiceImpl implements FundsAllocationplanService {

    @Value("${opapi.http.net}")
    private String opapiHttp;
    @Value("${clotho.http.net}")
    private String clothoHttp;

    @Override
    public boolean fundPlannedDistribution(String fundCorpId) throws Exception {
        Boolean boo=true;
      String  loginOPToken =loginOPToken();
        if(StringUtils.isBlank(loginOPToken)){
            return false;
        }else{
            boo= fundingPlan(fundCorpId);
            if(boo){
                return FundingPolicySave(fundCorpId);
            }else {
                return false;
            }
        }
    }

    @Override
    public String loginOPToken() {
        log.info("打印opapiHttp:{}",opapiHttp);
        String url = opapiHttp + "/user/login?auth=dXNlcj14dWV6aiZwYXNzd29yZD0xMjMxMjNxd2Vxd2U%3D";
        JSONObject result = HttpRequest.doGetReturnResponseJson(url);
        JSONObject resultData = (JSONObject) result.get("data");
        String businessCode=result.get("businessCode").toString().trim();
        if(ResposeResultEnum.BUSINESSCODE.getDesc().equals(businessCode)){
            log.info("打印token:{}",resultData.get("token").toString().trim());
            return resultData.get("token").toString().trim();
        }else{
           log.info("没有获取到token={}",result);
        }

        return null;
    }

    @Override
    public boolean fundingPlan(String fundCorpId) throws Exception {
        boolean boo=true;
        String url =clothoHttp + "/funds/plan/funding/plan/save";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("fundCorpId", fundCorpId);
        paras.put("planDate", CoverDate.getTimeShort());
        paras.put("maxAssignAmount", "10000000");
        paras.put("maxLoanAmount", "10000000");
        paras.put("maxLoanPeople", "1000");
        paras.put("maxAssignPeople", "1000");
        paras.put("priorityLevel", "1");

        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", loginOPToken());
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        String businessCode=result.get("businessCode").toString().trim();
        String code=result.get("code").toString().trim();
        if(ResposeResultEnum.BUSINESSCODE.getDesc().equals(businessCode) && ResposeResultEnum.BUSINESSCODE.getDesc().equals(code) ){
           boo=true;
        }else {
            boo=false;

        }
        return boo;
    }

    @Override
    public boolean FundingPolicySave(String fundCorpId) throws Exception {
        boolean boo=true;
        String url= opapiHttp+"/clotho/funds/plan/funding/policy/save";
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", loginOPToken());
//
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("fundingCorpId", fundCorpId);
        paras.put("minQgScore", "-1");
        paras.put("maxQgScore", "-1");
        paras.put("assignTimes", "0:00-23:59");
        paras.put("productType", "1");
        paras.put("pickProduct", "");
        paras.put("fetchConfig", "0:01");
        paras.put("autoLoanFetchConfig", "0:01");
        paras.put("priorityChannel", "");
        paras.put("banChannel", "");
        paras.put("loanTimes", "0:00-23:59");
        paras.put("onlyChannel", "159439");
        paras.put("isAutoAssign", "true");
        paras.put("isAutoLoan", "true");
        paras.put("isAutoFetch", "true");
        paras.put("autoLoanFetch", "true");


        JSONObject result = HttpRequest.doPostReturnResponseJson(url,paras, header);
        String businessCode=result.get("businessCode").toString().trim();
        String code=result.get("code").toString().trim();
        if(ResposeResultEnum.BUSINESSCODE.getDesc().equals(businessCode) && ResposeResultEnum.BUSINESSCODE.getDesc().equals(code) ){
            boo=true;
        }else {
            boo=false;

        }
        return boo;
    }

   public static void main(String[] arg){
       FundsAllocationplanServiceImpl fundsAllocationplanService=new FundsAllocationplanServiceImpl();
       fundsAllocationplanService.loginOPToken();

   }
}
