package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.implnew;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.utils.GetBiNoAndFinanceProducts;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class CreditGrantingServiceImpl implements CreditGrantingService{

    @Autowired
    private ApplyLoanService applyLoanService;

    @Autowired
    private PhoneInfoService phoneInfoService;

    @Autowired
    private OneClickDataRespository oneClickDataRespository;

    @Autowired
    private FundsAllocationplanServiceImpl fundsAllocationplanService;

    public final  static String txAmount = "2000";
    public final  static String rate = "0";
    @Value("${clotho.http.net}")
    private String clothoHttp;
    @Override
    public Result authAmountAuditNotify(OneClickModel oneClickModel) throws Exception {
      String  auditResult="true";

        if(String.valueOf(TypeEnum.CREDITSUCCESS.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.LOANSUCCESS.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.LOANFAIL.getCode()).equals(oneClickModel.getType())|| String.valueOf(TypeEnum.LIQUIDATION.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.CASHWITHDRAWAL.getCode()).equals(oneClickModel.getType())){
            auditResult="true";
        }else if(String.valueOf(TypeEnum.CREDITFAIL.getCode()).equals(oneClickModel.getType())){
            auditResult="false";
        }else {
            log.info("非授信需要的状态，打印一下oneClickModel.getType()={}",oneClickModel.getType());
        }
            return  applyCreditNotify(oneClickModel,auditResult,0);
    }

    @Override
    public Result authAmountAuditNotifyMq(OneClickData oneClickData, QuotaCredit quotaCredit) throws Exception {
        String  auditResult="true";
        if(String.valueOf(TypeEnum.CREDITSUCCESS.getCode()).equals(oneClickData.getType()) || String.valueOf(TypeEnum.LOANSUCCESS.getCode()).equals(oneClickData.getType()) || String.valueOf(TypeEnum.LOANFAIL.getCode()).equals(oneClickData.getType())|| String.valueOf(TypeEnum.LIQUIDATION.getCode()).equals(oneClickData.getType()) || String.valueOf(TypeEnum.CASHWITHDRAWAL.getCode()).equals(oneClickData.getType())){
            auditResult="true";
        }else if(String.valueOf(TypeEnum.CREDITFAIL.getCode()).equals(oneClickData.getType())){
            auditResult="false";
        }else {
            log.info("非授信需要的状态，打印一下oneClickModel.getType()={}",oneClickData.getType());
        }
        return  applyCreditNotifyMq(oneClickData, quotaCredit, auditResult);
    }

    public Result applyCreditNotify(OneClickModel oneClickModel,String auditResult,int num) throws Exception {
        String url = clothoHttp + "/external/quota/auth_amount_audit/notify";
        Map<String, String> paras = new HashMap<String, String>();
        ArrayList listPara1 =getPublicInfo(oneClickModel);
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel", "1");
        //通过手机号获取用户信息
       XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
        log.info("打印一下xUser：{}",xUser);
        String uuid=xUser.getUuid();
        Long userId=xUser.getId();
        paras.put("uuid", uuid);
        //通过用户id获取产品信息
        log.info("打印一下userid:{},oneClickModel:{}",userId,oneClickModel);
        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecordsNotCreditStatus(userId, Long.parseLong(oneClickModel.getChannel()));

        if (Objects.isNull(quotaCredit)){

            return Result.buildFail("授信记录未查询到quotaCredit！！！，请检查数据") ;
        }else{
            log.info("打印一下quotaCredit={}",quotaCredit);
        }

        int productId= Integer.parseInt(quotaCredit.getProductId().toString().trim()) ;
        String biNo = String.valueOf(quotaCredit.getProductType());
        String quotaRecordOrderNo=quotaCredit.getOrderNo();
        //获取产品分配基础信息，默认rate都是0
        HashMap<Object, Object> getBiNoAndFinanceProduct = GetBiNoAndFinanceProducts.getBiNoAndFinanceProduct(productId, listPara1);

        paras.put("bizNo", quotaRecordOrderNo);
        paras.put("bizType", biNo);
        paras.put("auditResult", auditResult);
        paras.put("amount", oneClickModel.getAmount());
        paras.put("deadLine", "1607746332000");
        paras.put("extData", "null");
        paras.put("otherInformation", "");
        paras.put("financeProducts", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());


        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        // 通过手机号和渠道code获取token
        String getToken=phoneInfoService.getToken(oneClickModel.getPhone(), oneClickModel.getChannel());
        header.put("x-auth-token", getToken);

        log.info("获取paras={},获取header={}",paras,header);
//        QuotaCredit quotaCredit1=phoneInfoService.selectUserAuditRecords(userId,  Long.parseLong(oneClickModel.getChannel()));
//        if (Objects.isNull(quotaCredit1)){
////            quotaCredit1=quotaCredit(userId, oneClickModel.getChannel().toString().trim(),0);
////            if(Objects.isNull(quotaCredit1)){
////                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
////
////            }
//            num++;
//            if(num <=3) {
//                applyCreditNotify(oneClickModel, auditResult, num);
//            }else {
//                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
//            }
//        }else{
//            log.info("打印一下quotaCredit1={}",quotaCredit1);
//        }
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        String statusCode=result.get("statusCode").toString().trim();
        String context=result.get("context").toString().trim();

        if("200".equals(statusCode) && "success".equals(context)){
             //从数据库中获取当前的订单
            log.info("userId={},CreditStatusEnum={},LoanStatusEnum={},channel={}", userId, CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode(),oneClickModel.getChannel());
            OneClickData oneClickData=oneClickDataRespository.findByUserIdAndCreditStatusAndLoanStatusAndChannelCode(userId.toString().trim(), CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode(), oneClickModel.getChannel().toString().trim());

            log.info("获取的实体oneClickData={}",oneClickData);
            //把授信请求通知的数据存放到表one_click_data中
           int update= oneClickDataRespository.updateById(quotaRecordOrderNo.toString().trim(), quotaRecordOrderNo.toString().trim(), String.valueOf(productId).toString().trim(), getToken.toString().trim(),quotaCredit.getProductType(), oneClickData.getId());
            // 跑一遍计划
            boolean fundplan=fundsAllocationplanService.fundPlannedDistribution(oneClickData.getFundCorpId());
            if(fundplan){
                log.info("自己分配计划ok",oneClickData);
            }else{
                log.info("自己分配计划失败：{}",oneClickData);
            }
           if (update>0){
               log.info("修改成功update={}",update);
           }else{
               log.info("修改失败 !!!!!");
           }
            return new Result(ApplicationStatus.SUCCESS,new OneClickOv(CreditStatusEnum.DEFAULT.getDesc()),"风控授信回调通知成功");
        }else{
            num++;
            log.info("打印循环次数num:{}",num);
            if(num <=3) {
                applyCreditNotify(oneClickModel, auditResult, num);
            }else {
                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
            }
            return Result.buildFail("风控授信回调通知成功失败！！！，请检查数据") ;

        }

    }


    public QuotaCredit quotaCredit(Long userId,Long channel,int num) throws InterruptedException {
        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(userId,channel);
        if(num<=5 && Objects.isNull(quotaCredit)){
            num++;
            log.info("打印一下num={}",num);
            quotaCredit(userId, channel, num);
        } else{
            log.info("打印一下最终的quotaCredit={}", quotaCredit);
        }
        return quotaCredit;
    }

    public Result applyCreditNotifyMq(OneClickData oneClickData, QuotaCredit quotaCredit,String auditResult) throws Exception {
        String url = clothoHttp + "/external/quota/auth_amount_audit/notify";
        Map<String, String> paras = new HashMap<String, String>();
        ArrayList listPara1 =getPublicInfoMq(oneClickData);
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel", "1");
        //通过手机号获取用户信息
        XUser xUser=phoneInfoService.selectUserID(oneClickData.getPhone());
        log.info("打印一下xUser：{}",xUser);
        String uuid=xUser.getUuid();
        Long userId=xUser.getId();
        paras.put("uuid", uuid);
        //通过用户id获取产品信息
        log.info("打印一下userid:{},oneClickModel:{}",userId,oneClickData);
        if (Objects.isNull(quotaCredit)){
            log.info("打印quotaCredit={}",quotaCredit);
            return Result.buildFail("授信记录未查询到quotaCredit！！！，请检查数据") ;
        }
        int productId= Integer.parseInt(quotaCredit.getProductId().toString().trim()) ;
        String biNo = String.valueOf(quotaCredit.getProductType());
        String quotaRecordOrderNo=quotaCredit.getOrderNo();
        //获取产品分配基础信息，默认rate都是0
        HashMap<Object, Object> getBiNoAndFinanceProduct = GetBiNoAndFinanceProducts.getBiNoAndFinanceProduct(productId, listPara1);

        paras.put("bizNo", quotaRecordOrderNo);
        paras.put("bizType", biNo);
        paras.put("auditResult", auditResult);
        paras.put("amount", oneClickData.getAmount().toString().trim());
        paras.put("deadLine", "1607746332000");
        paras.put("extData", "null");
        paras.put("otherInformation", "");
        paras.put("financeProducts", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());


        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        // 通过手机号和渠道code获取token
        String getToken=phoneInfoService.getToken(oneClickData.getPhone(), oneClickData.getChannel());
        header.put("x-auth-token", getToken);

        log.info("获取paras={},获取header={}",paras,header);

        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        String statusCode=result.get("statusCode").toString().trim();
        String statusCodeCompare="200";
        String context=result.get("context").toString().trim();
        String contextCompare="success";
        if(statusCodeCompare.equals(statusCode) && contextCompare.equals(context)) {

            //把授信请求通知的数据存放到表one_click_data中
            int update= oneClickDataRespository.updateById(quotaRecordOrderNo.toString().trim(), quotaRecordOrderNo.toString().trim(), String.valueOf(productId).toString().trim(), getToken.toString().trim(),quotaCredit.getProductType(), oneClickData.getId());
            // 修改授信状态授信成功CreditStatusEnum.CREDIT_SUCC
            oneClickDataRespository.updateCreditStatusById(CreditStatusEnum.CREDIT_SUCC.getCode(), oneClickData.getId());
            // 跑一遍计划
            boolean fundplan=fundsAllocationplanService.fundPlannedDistribution(oneClickData.getFundCorpId());
            if(fundplan){
                log.info("自己分配计划ok",oneClickData);
            }else{
                log.info("自己分配计划失败：{}",oneClickData);
            }
            if (update>0){
                log.info("修改成功update={}",update);
            }else{
                log.info("修改失败 !!!!!");
            }
            return new Result(ApplicationStatus.SUCCESS,new OneClickOv(CreditStatusEnum.DEFAULT.getDesc()),"风控授信回调通知成功");
        }else{
            return Result.buildFail("风控授信回调通知成功失败！！！，请检查数据") ;
        }
    }


    public ArrayList getPublicInfo(OneClickModel oneClickModel){
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, oneClickModel.getAmount());
        listPara1.add(1, oneClickModel.getTermNo());
        listPara1.add(2, oneClickModel.getFundID());
        listPara1.add(3, rate);
        listPara1.add(4, txAmount);
        return listPara1;

    }

    public ArrayList getPublicInfoMq(OneClickData oneClickData){
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, oneClickData.getAmount().toString().trim());
        listPara1.add(1, oneClickData.getTermNo());
        listPara1.add(2, oneClickData.getFundCorpId());
        listPara1.add(3, rate);
        listPara1.add(4, txAmount);
        return listPara1;

    }
}
