package cn.quantgroup.cashloanflowboss.api.permissionmodule.controller;

import cn.quantgroup.cashloanflowboss.api.permissionmodule.model.PermissionVO;
import cn.quantgroup.cashloanflowboss.api.permissionmodule.service.IPermissionService;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * function:
 * date: 2019/9/26
 *
 * @author: suntao
 */
@RestController
@RequestMapping("permission")
public class PermissionController {


    @Autowired
    private IPermissionService permissionService;
    /**
     * 角色 未拥有的权限
     * @param roleId
     * @return
     */
    @GetMapping("outOfRolePermission")
    @Security(authorityId = "Permission.outOfRolePermission")
    public Result outOfRolePermission(Long roleId) {
        return null;
    }


    /**
     * 权限列表
     * @return
     */
    @GetMapping("all")
    //@Security(authorityId = "Permission.permissionList")
    public Result permissionList() {

        return permissionService.getAll();
    }

    /**
     * 保存权限
     * @param permissionVO
     * @return
     */
    @PostMapping("save")
    @Security(authorityId = "Permission.savePermission")
    public Result savePermission(PermissionVO permissionVO) {
        return null;
    }


    /**
     * 删除权限
     * @param permissionVO
     * @return
     */
    @PostMapping("delete")
    @Security(authorityId = "Permission.delete")
    public Result delete(PermissionVO permissionVO) {
        return null;
    }



}
