package cn.quantgroup.cashloanflowboss.component.security.annotiation;

import cn.quantgroup.cashloanflowboss.component.security.SecurityConfigurationSelector;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by WeiWei on 2018/2/1.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(SecurityConfigurationSelector.class)
public @interface EnableSecurity {

    /**
     * 是否使用子类代理目标类
     *
     * @return
     */
    boolean proxyTargetClass() default false;

    /**
     * 代理模式
     *
     * @return
     */
    AdviceMode mode() default AdviceMode.PROXY;

    /**
     * 排序
     *
     * @return
     */
    int order() default Ordered.HIGHEST_PRECEDENCE;

}
