package cn.quantgroup.cashloanflowboss.validator.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Collection;
import java.util.Objects;

/**
 * 空值约束验证器
 *
 * Created by WeiWei on 2017/8/9.
 */
public class NotEmptyValidator implements ConstraintValidator<NotEmpty, Object> {

    private NotEmpty annotation;

    public NotEmptyValidator() {

    }

    @Override
    public void initialize(NotEmpty constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {

        if(Objects.isNull(value)) {
            return this.annotation.nullable();
        }

        return Collection.class.isInstance(value) ? !((Collection) value).isEmpty() : String.class.isInstance(value) ? !((String) value).isEmpty() : true;

    }

}
