package cn.quantgroup.cashloanflowboss.validator.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * 邮箱格式约束验证器
 *
 * Created by WeiWei on 2017/8/9.
 */
public class EmailValidator implements ConstraintValidator<Email, CharSequence> {

    private Email annotation;

    public EmailValidator() {

    }

    @Override
    public void initialize(Email constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {

        if(Objects.isNull(value)) {
            return this.annotation.nullable();
        }

        return Pattern.matches(this.annotation.regularExpression(), value);

    }

}
