package cn.quantgroup.cashloanflowboss.validator.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Calendar;
import java.util.Objects;

/**
 * 时间范围约束验证器
 *
 * Created by WeiWei on 2017/8/9.
 */
public class DateRangeValidator implements ConstraintValidator<DateRange, Long> {

    private DateRange annotation;

    public DateRangeValidator() {

    }

    @Override
    public void initialize(DateRange constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(Long value, ConstraintValidatorContext context) {

        if(Objects.isNull(value)) {
           return this.annotation.nullable();
        }

        Long currentTime = Calendar.getInstance().getTimeInMillis();

        Long startTime = this.annotation.startTime() == 0 ? currentTime : this.annotation.startTime();

        Long endTime = this.annotation.endTime() == 0 ? currentTime : this.annotation.endTime();

        Long offset = this.annotation.offset();

        if(value < (startTime - offset) || value > (endTime + offset)) {
            return false;
        }

        return true;

    }

}
