package cn.quantgroup.cashloanflowboss.spi.gyxd.repository;


import cn.quantgroup.cashloanflowboss.spi.gyxd.entity.LoanApplicationManifestHistory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * Created by admin on 2016/8/23.
 */
public interface ILoanApplicationManifestHistoryRepository extends JpaRepository<LoanApplicationManifestHistory, Long>, JpaSpecificationExecutor<LoanApplicationManifestHistory> {

    /**
    * @param loanId
     * @return  LoanApplicationManifestHistory
    * */

    LoanApplicationManifestHistory findByLoanId(String loanId);

    /**
    * @param ids
     * @return  LoanApplicationManifestHistory
    * */
    @Query(value = "select * from loan_application_manifest_history where loan_id in (?1)", nativeQuery = true)
    List<LoanApplicationManifestHistory> findByLoanIds(List<String> ids);

    /**
     * 修改订单状态
     * @param loanId
     * @param loanProgress
     * @return int
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "UPDATE loan_application_manifest_history SET loan_progress=?2,updated_at=CURRENT_TIMESTAMP WHERE loan_id =?1 ", nativeQuery = true)
    int updateLoanProgress(String loanId, Integer loanProgress);
}
