package cn.quantgroup.cashloanflowboss.spi.clotho.service;

import cn.quantgroup.cashloanflowboss.spi.clotho.client.ClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.clotho.model.LendingServiceModel;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Slf4j
@Service
public class ClothoCenterService {

    @Autowired
    private ClothoCenter clothoCenter;

    /**
     * 生成放款MQ消息
     *
     * @return
     */
    public String generatorLendingMessage(LendingServiceModel lendingServiceModel) {
        return this.clothoCenter.generatorLendingMessage(JSONTools.toMap(lendingServiceModel));
    }

    /**
     * 放款
     *
     * @return
     */
    public boolean lending(Integer fundId, BigDecimal amountLimit, Integer pepoleLimit) {

        // TODO WEIWEI 根据返回的数据结构补充判断逻辑

        String data = this.clothoCenter.lending(new HashMap() {{
            put("fundingCorpId", fundId);
            put("amountLimit", amountLimit);
            put("peopleLimit", pepoleLimit);
        }});

        return false;
        
    }

}
