package cn.quantgroup.cashloanflowboss.api.order.util;

import cn.quantgroup.cashloanflowboss.api.order.entity.OrderApprove;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.api.order.model.QueryXyqbOrderStatus;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */
public class OrderUtil {
    public static final String financeProductsFormat = "[{\"min\":%s,\"max\":%s,\"terms\":[{\"term\":%s,\"fundInfo\":[{\"fundId\":%s,\"rate\":\"0\",\"rateType\":1,\"priority\":\"1\",\"feeType\":\"1\"}]}]}]";


    public static Tuple<String, List<OrderVo.OptButton>> getCurrentStatusAndButtons(QueryXyqbOrderStatus currentStatus, OrderApprove orderApprove) {
        Tuple tuple = new Tuple();
        List<OrderVo.OptButton> buttonList = new ArrayList<>();

        if (currentStatus != null) {
            if (StringUtils.isNotEmpty(currentStatus.getStatus())) {
                OrderVo.OptButton buttonBeforeCancel = new OrderVo.OptButton();
                buttonBeforeCancel.setAction(OrderVo.OptButtonAction.cancel.name());
                buttonBeforeCancel.setName(OrderVo.OptButtonAction.cancel.getDesc());
                switch (currentStatus.getStatus()) {
                    case "CREDIT_SUCC" :
                        // 授信成功 需要 审批
                        OrderVo.OptButton buttonApprove = new OrderVo.OptButton();
                        buttonApprove.setAction(OrderVo.OptButtonAction.audit.name());
                        buttonApprove.setName(OrderVo.OptButtonAction.audit.getDesc());
                        buttonList.add(buttonApprove);
                        buttonList.add(buttonBeforeCancel);
                        tuple.setKey("授信成功");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "APPROVE_ING" :
                        if (orderApprove == null) {
                            OrderVo.OptButton buttonApprove2 = new OrderVo.OptButton();
                            buttonApprove2.setAction(OrderVo.OptButtonAction.audit.name());
                            buttonApprove2.setName(OrderVo.OptButtonAction.audit.getDesc());
                            buttonList.add(buttonApprove2);
                            buttonList.add(buttonBeforeCancel);
                            tuple.setKey("授信成功,待审批");
                            tuple.setValue(buttonList);
                        } else {
                            tuple.setKey("审批中");
                            buttonList.add(buttonBeforeCancel);
                            tuple.setValue(buttonList);
                        }
                        return tuple;
                    case "REJECT" :
                        tuple.setKey("审批拒绝");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUAD_ASSIFN_SUCC" :
                        tuple.setKey("审批通过，待提现");
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "WITHDRAW" :
                        // 提现申请成功 需要放款
                        tuple.setKey("申请提现成功");
                        OrderVo.OptButton buttonPaySucc = new OrderVo.OptButton();
                        buttonPaySucc.setAction(OrderVo.OptButtonAction.pay_succ.name());
                        buttonPaySucc.setName(OrderVo.OptButtonAction.pay_succ.getDesc());
                        buttonList.add(buttonPaySucc);
                        OrderVo.OptButton buttonPayFail = new OrderVo.OptButton();
                        buttonPayFail.setAction(OrderVo.OptButtonAction.pay_fail.name());
                        buttonPayFail.setName(OrderVo.OptButtonAction.pay_fail.getDesc());
                        buttonList.add(buttonPayFail);
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "PAY_ING" :
                        tuple.setKey("放款中");
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_SUCC" :
                        if (orderApprove != null && orderApprove.getFundType() != 0) {
                            // 是存管
                            tuple.setKey("放款到存管，待提现");
                            OrderVo.OptButton cancelAfterButton = new OrderVo.OptButton();
                            cancelAfterButton.setAction(OrderVo.OptButtonAction.cancel_after.name());
                            cancelAfterButton.setName(OrderVo.OptButtonAction.cancel_after.getDesc());
                            buttonList.add(cancelAfterButton);
                            OrderVo.OptButton withdrawSecondButton = new OrderVo.OptButton();
                            withdrawSecondButton.setAction(OrderVo.OptButtonAction.withdraw_second.name());
                            withdrawSecondButton.setName(OrderVo.OptButtonAction.withdraw_second.getDesc());
                            buttonList.add(withdrawSecondButton);
                        } else {
                            tuple.setKey("放款成功");
                        }
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_WITHDRAW_SUCC" :
                        tuple.setKey("存管提现成功");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_FAIL" :
                        tuple.setKey("放款失败");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "ALL_REPAID" :
                        tuple.setKey("已结清");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "CANCEL_LOAN" :
                        tuple.setKey("已关单");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "CANCEL_AFTER_LOAN" :
                        tuple.setKey("存管提现超时或贷后关单");
                        tuple.setValue(buttonList);
                        return tuple;
                    default:
                        tuple.setKey("未知状态");
                        tuple.setValue(buttonList);
                        return tuple;
                }
            }

        } else {
            tuple.setKey("未知状态");
            tuple.setValue(buttonList);
            return tuple;
        }
        tuple.setKey("未知状态");
        tuple.setValue(buttonList);
        return tuple;
    }
}
