package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.spi.xyqb.client.XYQBCenter;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundLending;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.CancelPreLoanRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.ContractRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.FundLendingRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.util.SignUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Service
public class XYQBCenterService {

    @Autowired
    private FundLendingRepository fundLendingRepository;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private CancelPreLoanRepository cancelPreLoanRepository;



    @Autowired
    private XYQBCenter xyqbCenter;

    /**
     * 更新资方待放款创建时间
     *
     * @return
     */
    public boolean updateFundLendingTime(Long loanId) {
        return this.fundLendingRepository.updateCreateTime(loanId, new Date());
    }

    /**
     * 更新合同状态
     *
     * @param userId
     * @return
     */
    @Transactional
    public int updateContractStatus(Long userId, Integer status) {
        return this.contractRepository.updateContractStatus(userId, status);
    }

    /**
     * 查询放款记录
     *
     * @param fundId
     * @param progress
     * @return
     */
    public Map queryLendingRecordCount(Integer fundId, Integer progress) {
        return this.fundLendingRepository.queryLendingRecordCount(fundId, progress);
    }


    /**
     * 贷前取消借款
     * @param channelOrderNumber
     * @return
     */
    public Long cancelPreLoan(String channelOrderNumber) {
        return cancelPreLoanRepository.cancelPreLoan(channelOrderNumber);
    }


    /**
     * 通过userId获取合同
     * @param userId
     * @return
     */
    public Contract findContractByUserId(Long userId) {
        return contractRepository.findByUserIdLastOne(userId);
    }

    /**
     * 保存合同
     * @param contract
     */
    public void saveContract(Contract contract) {
        contractRepository.save(contract);
    }

    public FundLending findFundLendingByLoanId(Long loanId) {
        return fundLendingRepository.findByLoanId(loanId);
    }

    public void saveFundLending(FundLending fundLending) {
        fundLendingRepository.save(fundLending);
    }



    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getXyqbOrderStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getOrderStatus(paramMap);
    }

    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getXyqbOrderHistoryStatus(paramMap);
    }

    /**
     * 放款 放款结果通知
     * @param loanId 订单loanId
     * @param expectPayResult 期望放款结果 true 放款成功 false 放款失败
     * @return
     */
    public boolean payResultNotify(Long loanId, Boolean expectPayResult) {
        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", loanId);
        paramMap.put("payOrderNo", loanId);
        paramMap.put("payTime", "");
        paramMap.put("payStatus", expectPayResult ? 3 : 4);
        return "success".equals(xyqbCenter.pushLendingResult(paramMap));
    }

}
