package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.CreditStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ResposeResultEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.TypeEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.*;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * Created by shang on 2019/12/19.
 */
@Slf4j
@Service
public class OneClickDataQueueOperateServiceImpl implements OneClickDataQueueOperateService {

    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CashWithdrawalService cashWithdrawalService;
    @Autowired
    private LoanOperationService loanOperationService;
    @Autowired
    private CreditGrantingService creditGrantingService;
    @Autowired
    private RepaymentPlatService repaymentPlatService;
    @Autowired
    private XYQBCenterService xyqbCenterService;

    @Override
    public void getCreditNotifyIsSucess(String queueMsg) {
        JSONObject queueMsgJson=(JSONObject)JSONObject.parse(queueMsg);
        JSONObject data=(JSONObject)queueMsgJson.get("data");
        String applyNo=data.get("applyNo").toString().trim();
        String  extraData=queueMsgJson.get("extraData").toString();
        String noticeType=queueMsgJson.get("noticeType").toString().trim();
        log.info("获取data:{},applyNo:{}",data,applyNo);
        OneClickData oneClickData= oneClickDataRespository.findByOrderNoOrChannelOrderNo(applyNo);
        log.info("获取oneClickData:{},获取noticeType:{}",oneClickData,noticeType);
        if(Objects.isNull(oneClickData)){
        }else{
             if(ResposeResultEnum.FUAD_ASSIFN_SUCC.getDesc().equals(noticeType)){
                getFundAssifnSucc(oneClickData);
            } else if(ResposeResultEnum.FUND_SUCC.getDesc().equals(noticeType)){
                // 提现成功了，收到放款成功消息，修改oneClickData的放款状态
                int num= oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.CHECK_REPAYMENT_PLAN.getCode(), oneClickData.getId());
                if(num>0){
                    log.info("oneClickData修改放款状态成功");
                }else{
                    log.info("oneClickData修改放款状态失败");
                }
                 if(oneClickData.getType() == TypeEnum.LIQUIDATION.getCode()){
                     log.info("进入还款流程中");
                     getApplyRepament(oneClickData);
                    }
            }else{
                log.info("没有找到对应需要处理的订单");
            }
        }


    }

    public void getApplyRepament(OneClickData oneClickData){
        repaymentPlatService.whetherHaveRepayment0rdersList(oneClickData);
    }

    public void authAmountAuditNotify(OneClickData oneClickData, QuotaCredit quotaCredit)throws Exception{
        if(oneClickData.getType() != TypeEnum.APPLY.getCode()) {
            creditGrantingService.authAmountAuditNotifyMq(oneClickData, quotaCredit);
        }else{
            log.info("进件申请流程无需走后续的授信流程:{}", oneClickData.getType());
        }
    }

    public void getFundAssifnSucc(OneClickData oneClickData){
        // 修改授信状态授信成功CreditStatusEnum.CREDIT_SUCC
        oneClickDataRespository.updateCreditStatusById(CreditStatusEnum.CREDIT_SUCC.getCode(), oneClickData.getId());
        // 放款成功、放款失败、清单、提现的流程需要进行提现操作
        if(oneClickData.getType() == TypeEnum.LOANSUCCESS.getCode() ||oneClickData.getType() == TypeEnum.LOANFAIL.getCode() ||oneClickData.getType() == TypeEnum.LIQUIDATION.getCode() ||oneClickData.getType() == TypeEnum.CASHWITHDRAWAL.getCode()){
            //执行提现操作
            Result cashWithdrawalResult= cashWithdrawalService.applyLoan(oneClickData);
            log.info("绑卡结果cashWithdrawalResult={}",cashWithdrawalResult);
            isNotSecondaryRiskControl(cashWithdrawalResult, oneClickData);
        }
    }

    @Override
    public Result commonFundAssifnSucc(OneClickData oneClickData){
        // 修改授信状态授信成功CreditStatusEnum.CREDIT_SUCC
        oneClickDataRespository.updateCreditStatusById(CreditStatusEnum.CREDIT_SUCC.getCode(), oneClickData.getId());
            //执行提现操作
            Result cashWithdrawalResult= cashWithdrawalService.applyLoan(oneClickData);
            log.info("绑卡结果cashWithdrawalResult={}",cashWithdrawalResult);
            isNotSecondaryRiskControl(cashWithdrawalResult, oneClickData);
        return cashWithdrawalResult;
    }

    public void isNotSecondaryRiskControl(Result cashWithdrawalResult,OneClickData oneClickData){
        if(cashWithdrawalResult.getCode() == ApplicationStatus.SUCCESS.getCode()){
            // 提现成功了，返回绑卡成功了，进行二次风控操作
            executeTheLendingProcess(oneClickData);
        }else{
            //提现请求失败后，修改提现绑卡失败
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.BIND_FAIL.getCode(), oneClickData.getId());

        }
    }

    public void executeTheLendingProcess(OneClickData oneClickData){
       //查询通过userid businessType isactive查询是否生成了放款单

        LoanApplicationHistory loanApplicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());

        if (Objects.isNull(loanApplicationHistory)){
            // 提现成功了，但是未在放款表查看到放款单
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.BIND_SUCC_NOTHAVEFUNDORDER.getCode(), oneClickData.getId());

        }else{
             log.info("获取到loanApplicationHistory={}", loanApplicationHistory);
            //如果返回绑卡成功，修改放款loandid 修改提现成功
            int updatenum= oneClickDataRespository.updateCreditStatusAndLoanStatusById(String.valueOf(loanApplicationHistory.getId()), LoanStatusEnum.APPLY_WITHDRAWDEPOSIT.getCode(), oneClickData.getId());
            if(updatenum >0){
                log.info("修改数据成功");
            }else{
                log.info("修改数据失败");
            }
            // 放款成功、放款失败、清单的流程需要进行二次风控操作
            if( oneClickData.getType() != TypeEnum.CASHWITHDRAWAL.getCode()) {
                log.info("当前的流程类型oneClickData.getType()={}",oneClickData.getType());
                oneClickData= oneClickDataRespository.findByLoanId(loanApplicationHistory.getId().toString().trim());
                getBingSucc(oneClickData);
            }
        }
    }

    @Override
    public void getBingSucc(OneClickData oneClickData){
            //执行二次风控
            JSONObject result= loanOperationService.orderAuditNotify(oneClickData);
        log.info("二次风控结果result：{}",result);
            isNotSecondRiskSucc(result, oneClickData);


    }


    public void isNotSecondRiskSucc(JSONObject result,OneClickData oneClickData){
        String statusCode=result.get("statusCode").toString().trim();
        String context=result.get("context").toString().trim();
        if(ResposeResultEnum.STATUSCODE.getDesc().equals(statusCode) && ResposeResultEnum.CONTEXT.getDesc().equals(context)){
            // 查看当前的放款单的状态是20
            LoanApplicationHistory loanApplicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());
            log.info("获取查询的二次风控请求成功后的loanApplicationHistory={}",loanApplicationHistory);
            log.info("打印一下progress={},LoanProgress.WAITING_FUND获取的值：{}",loanApplicationHistory.getProgress().getDescription(),LoanProgress.WAITING_FUND.getDescription());
            // 获取的放款状态是 "发起提现,等待二次风控审核"  "等待马上金融放款" "已发送给马上金融, 等待放款"
            String progress=loanApplicationHistory.getProgress().getDescription().trim();
           // LoanProgress.START_ORDER尚未成功二次风控哦？？
            if(LoanProgress.WAITING_FUND.getDescription().equals(progress) || LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().equals(progress)){
                updateContrantAndApplyLendingNotify(oneClickData);
            }else if(LoanProgress.START_ORDER.getDescription().equals(progress)){
                log.info("二次风控放款没有返回20，仍然是50重新操作一遍");
            }else{
                log.info("风控=loanApplicationHistory",loanApplicationHistory);
                // 放款状态：二次风控放款失败
               int updatanum= oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.SECONDARYRISKCONTROLFAILURE.getCode(), oneClickData.getId());
              if(updatanum>0){
                  log.info("二次风控放款失败,二次风控修改成功");
              }else{
                  log.info("二次风控放款失败,二次风控失败修改失败");

              }
            }

        }else {
            // 放款状态：二次风控放款失败
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.SECONDARYRISKCONTROLFAILURE.getCode(), oneClickData.getId());
        }
    }

    public void updateContrantAndApplyLendingNotify(OneClickData oneClickData){
        LoanApplicationHistory loanApplicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());
        // 放款状态：等待马上金融放款20
        String progress=loanApplicationHistory.getProgress().getDescription().trim();
        log.info("查看修改合同之前的放款状态progress={}",progress);
        if(LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().equals(progress)){
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.TO_JRWAITLOAN.getCode(), oneClickData.getId());
        }else {
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.WAIT_JRLOAN.getCode(), oneClickData.getId());
        }
        boolean boo= loanOperationService.updatContractStatus(oneClickData);
        if(boo){
            log.info("合同修改成功！！！");
            //申请放款操作
            applyLendingNotify(oneClickData);

        }else{
            //修改合同失败
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.NOTHAVECONTRACT.getCode(), oneClickData.getId());
        }
    }

    @Override
    public JSONObject applyLendingNotifyOnly(OneClickData oneClickData){
        JSONObject result=null;
                // 检查当前的合同是否更新状态
        Contract contract= xyqbCenterService.findContractByUserId(Long.parseLong(oneClickData.getUserId()));
         if(Objects.nonNull(contract)){
             log.info("查到当前的合同contract={}", contract);
             if(contract.getGenerateStatus() != Integer.parseInt(ResposeResultEnum.GENERATESTATUS.getDesc())){
                 updatContractStatus(oneClickData);
             }
         }else {
             log.info("当前的合同状态是对的contract.getGenerateStatus() ={}", contract.getGenerateStatus());

         }
        String payStatus="3";
        // 通过申请类型确定是否要放款成功、失败
        // 放款成功、清单修改状态成功，放款失败修改状态失败
        if(oneClickData.getType() == TypeEnum.LOANFAIL.getCode() ){
            payStatus="4";
        }else {
            payStatus="3";
        }
         result= loanOperationService.fundsPlanLoanApply(oneClickData, payStatus);

            log.info("放款结果result={}", result);
        // 放款结果判断
        isOkLoan(result,oneClickData);

        return result;
    }


    public void applyLendingNotify(OneClickData oneClickData){
        String payStatus="3";
        // 通过申请类型确定是否要放款成功、失败
        // 放款成功、清单修改状态成功，放款失败修改状态失败
        if(oneClickData.getType() == TypeEnum.LOANFAIL.getCode() ){
            payStatus="4";
        }else {
            payStatus="3";
        }
        JSONObject result= loanOperationService.fundsPlanLoanApply(oneClickData, payStatus);

        log.info("放款结果result={}",result);
        // 放款结果判断
        isOkLoan(result,oneClickData);


    }

    public void   isOkLoan(JSONObject result,OneClickData oneClickData){
        //这边判断有问题需要改
        boolean isOk=false;
        String businessCodeKey="businessCode";
        String codeKey="code";
      if (result.containsKey(businessCodeKey) && result.containsKey(codeKey)) {
          String businessCode = result.get("businessCode").toString().trim();
          String code = result.get("code").toString().trim();
          if (StringUtils.isNotEmpty(businessCode) && StringUtils.isNotEmpty(code)) {
               isOk=(businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc()) && code.equals(ResposeResultEnum.BUSINESSCODE.getDesc())) ;

          } else {
              oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.LOAN_REQUEST_NULL.getCode(), oneClickData.getId());

          }
      }
        String statusCodeKey="statusCode";
        String contextKey="context";
      if(result.containsKey(statusCodeKey) && result.containsKey(contextKey)) {
          String statusCode = result.get("statusCode").toString().trim();
          String context = result.get("context").toString().trim();
          if (StringUtils.isNotEmpty(statusCode) && StringUtils.isNotEmpty(context)) {
              isOk = (statusCode.equals(ResposeResultEnum.STATUSCODE.getDesc()) && context.equals(ResposeResultEnum.CONTEXT_SUCCESS.getDesc()));
          }else {
              oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.LOAN_REQUEST_NULL.getCode(), oneClickData.getId());

          }
      }
        if (isOk) {
            log.info("获取当前的isOk={}",isOk);
            // 查看当前的放款单的状态是21
            LoanApplicationHistory loanApplicationHistory = loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());
            log.info("放款请求成功后的loanApplicationHistory={}", loanApplicationHistory);
            String progress1=loanApplicationHistory.getProgress().getDescription().trim();
            if (LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().equals(progress1)) {
                //修改打款状态21
                oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.TO_JRWAITLOAN.getCode(), oneClickData.getId());
            }else if(LoanProgress.CHECK_REPAYMENT_PLAN.getDescription().equals(progress1)){
                // 提现成功了，收到放款成功消息，修改oneClickData的放款状态
                oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.CHECK_REPAYMENT_PLAN.getCode(), oneClickData.getId());
            } else if(LoanProgress.FINAL_FUNDED_APPROVAL_FAIL.getDescription().equals(progress1)){
                // 提现成功了，收到放款失败消息，修改oneClickData的放款状态
                oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.FINAL_FUNDED_APPROVAL_FAIL.getCode(), oneClickData.getId());
            }else {
                log.info("放款请求成功，但是查询库中的状态不对progress1={}",progress1);
                //直投打款成功，但状态不对
                oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.DIRECT_INVESTMENT_SUCCESS_STATUSNOTRIGHT.getCode(), oneClickData.getId());
            }
            //放款失败的逻辑需要添加
        } else {
            log.info("返回结果不对isOk");
            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.LOAN_REQUEST_FAILED.getCode(), oneClickData.getId());

        }
    }

   public void updatContractStatus(OneClickData oneClickData){
       boolean boo= loanOperationService.updatContractStatus(oneClickData);
       if(boo){
           log.info("合同修改成功！！！");


       }else{
           //修改合同失败
           oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.NOTHAVECONTRACT.getCode(), oneClickData.getId());
       }
   }
    public static void main(String[] arg){
//        String queueMsg="{\"data\":{\"applyNo\":\"FM624168161855715731904356\",\"loanId\":0,\"loanProgress\":\"LOAN_APPLICATION_MANIFEST_COMPLETE\",\"termNo\":-1},\"extraData\":\"{\\\"amount\\\":\\\"10000.00\\\",\\\"annualInterest\\\":\\\"0.36\\\",\\\"assignTime\\\":1577153040895,\\\"term\\\":\\\"12\\\"}\",\"noticeType\":\"FUAD_ASSIFN_SUCC\"}\n";
        System.out.print(LoanProgress.WAITING_FUND.toString());
    }
}
