package cn.quantgroup.cashloanflowboss.component.security;

import cn.quantgroup.cashloanflowboss.component.security.annotiation.EnableSecurity;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;
import org.springframework.context.annotation.AutoProxyRegistrar;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by WeiWei on 2018/2/1.
 */
public class SecurityConfigurationSelector extends AdviceModeImportSelector<EnableSecurity> {

    @Override
    protected String[] selectImports(AdviceMode adviceMode) {

        switch (adviceMode) {
            case PROXY:
                return getProxyImports();
            case ASPECTJ:
                return getAspectJImports();
            default:
                return null;
        }

    }

    /**
     * 动态代理
     *
     * @return
     */
    private String[] getProxyImports() {

        List<String> result = new ArrayList<>();
        result.add(AutoProxyRegistrar.class.getName());
        result.add(SecurityConfiguration.class.getName());

        return result.toArray(new String[result.size()]);

    }

    /**
     * AspectJ代理
     *
     * @return
     */
    private String[] getAspectJImports() {
        // TODO 尚未支持
        return null;
    }

}
