package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * Created by QuantGroup on 2018/3/21.
 * 额度产品表
 */
@Entity
@Table(name = "quota_product")
@Data
public class QuotaProduct {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 渠道ID
     */
    @Column(name = "channel_id")
    private Long channelId;

    /**
     * 产品类型  0：现金贷 1：白条 2 循环额度
     */
    @Column(name = "product_type")
    private Integer productType;

    /**
     * 产品描述
     */
    @Column(name = "product_desc")
    private String productDesc;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 是否启用标志位
     */
    @Column(name = "is_active")
    private Boolean isActive;

    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @Column(name = "updated_at")
    private Timestamp updatedAt;


    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
