# ************************************************************
# Sequel Pro SQL dump
# Version 5129
#
# https://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 172.17.5.9 (MySQL 5.6.43-log)
# Database: cash_loan_flow_boss
# Generation Time: 2019-10-22 10:49:53 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
SET NAMES utf8mb4;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table channel_conf
# ------------------------------------------------------------

DROP TABLE IF EXISTS `channel_conf`;

CREATE TABLE `channel_conf` (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '物理主键',
  `channel_id` bigint(8) DEFAULT NULL COMMENT '量化派对渠道标记；渠道号',
  `channel_code` varchar(32) DEFAULT '' COMMENT '渠道code',
  `channel_name` varchar(32) DEFAULT '' COMMENT '渠道code',
  `env` varchar(64) DEFAULT '' COMMENT '测试环境',
  `fund_id` bigint(32) DEFAULT NULL COMMENT '资方id',
  `p2p_fund_id` bigint(32) DEFAULT NULL COMMENT '存管资方id',
  `biz_type` bigint(32) DEFAULT NULL COMMENT '业务产品类型productId',
  `aes_key` varchar(64) DEFAULT NULL COMMENT 'aesKey',
  `md5_key` varchar(64) DEFAULT NULL COMMENT 'md5Key',
  `auth_code` varchar(64) DEFAULT NULL COMMENT '提交授信code',
  `risk_code` varchar(64) DEFAULT NULL COMMENT '提交爬虫数据code',
  `env_path` varchar(64) DEFAULT NULL COMMENT '环境域名',
  `channel_ip` varchar(64) DEFAULT NULL COMMENT '渠道ip',
  `approve_call_back_url` varchar(256) DEFAULT NULL COMMENT '审批回调地址',
  `order_status_call_back_url` varchar(256) DEFAULT NULL COMMENT '订单状态回调地址',
  `repay_result_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款结果回调地址',
  `repayment_plan_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款计划回调地址',
  `message` text,
  `extend_data` text COMMENT '扩展信息',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_channel_id` (`channel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='渠道配置表';

LOCK TABLES `channel_conf` WRITE;
/*!40000 ALTER TABLE `channel_conf` DISABLE KEYS */;

INSERT INTO `channel_conf` (`id`, `channel_id`, `channel_code`, `channel_name`, `env`, `fund_id`, `p2p_fund_id`, `biz_type`, `aes_key`, `md5_key`, `auth_code`, `risk_code`, `env_path`, `channel_ip`, `approve_call_back_url`, `order_status_call_back_url`, `repay_result_call_back_url`, `repayment_plan_call_back_url`, `message`, `extend_data`, `create_time`, `update_time`)
VALUES
	(1,159858,'ZHANGZHONG','掌众','ka2',800,630,9,'1IE3lj7JVMXUZgxZ','3dc1yCYD','xysqZhangZhongJRXjd','ZHANGZHONGJR','http://qapi-ka2.liangkebang.net/','127.0.0.1','https://esjrd.weshare.com.cn/terminator/gdxd/notify/audit','https://esjrd.weshare.com.cn/terminator/gdxd/notify/pay','https://esjrd.weshare.com.cn/terminator/gdxd/notify/repaymentplan','https://esjrd.weshare.com.cn/terminator/gdxd/notify/repaymentplan',NULL,NULL,'2019-08-07 16:07:36','2019-09-19 10:05:06'),
	(2,123456,'TEST_123456','利川掏掏','ka2',480,630,1,'1234567890123456','12345678','authCode','riskCode','http://qapi-ka2.liangkebang.net/','127.0.0.1','http://approveCallBackUrl2','http://orderStatusCallBackUrl2','http://repayResultCallBackUrl2','http://repaymentCallBackUrl2',NULL,NULL,'2019-08-09 17:05:39','2019-08-28 15:15:42'),
	(4,159865,'SHIGUANGFQ','时光分期','qa',480,630,9,'r3KlPls9cZKye2Xj','gDDIy6uJ','xysqShiGuangFQXjd','SHIGUANGFQ','http://qapi-qa.liangkebang.net/','127.0.0.1','http://124.251.102.83/risk/core_huangjiajun24/gateway','http://124.251.102.83/risk/core_huangjiajun24/gateway','http://124.251.102.83/risk/core_huangjiajun24/gateway','http://124.251.102.83/risk/core_huangjiajun24/gateway',NULL,NULL,'2019-08-09 17:05:39','2019-09-20 16:44:49'),
	(5,159753,'ANJIAQUHUA','安家趣花','ka2',540,480,0,'I7uKKxoqsNivHrYs','txUSQK5u','xysqAnJiaQuHuaXjd','ANJIAQUHUA','http://qapi-ka2.liangkebang.net/','','http://ajqh-app-prod.apass.cn/appwebv2/xyqb/push/credit','http://ajqh-app-prod.apass.cn/appwebv2/xyqb/push/order/status','','http://ajqh-app-prod.apass.cn/appwebv2/xyqb/push/repay/plan',NULL,NULL,'2019-09-03 16:57:28','2019-09-03 16:57:28'),
	(6,159866,'liandong','联动','',0,0,0,'sxD8KO79EDK0N0AJ','qEAxMJBv','xysqZhangZhongJRXjd','ZHANGZHONGJR','http://qapi-.liangkebang.net/','','','','','',NULL,NULL,'2019-09-10 17:39:37','2019-09-10 17:57:25'),
	(10,1234567,'test2','测试2','ka2',480,640,9,'aes_test','md5_test','auth','rish','http://qapi-ka2.liangkebang.net/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-10 18:21:07','2019-09-23 11:17:07'),
	(11,333,'R360','融360','ka2',480,540,0,'','','xysqRong360','R360','http://qapi-ka2.liangkebang.net/','','','','','',NULL,NULL,'2019-09-12 15:17:33','2019-09-12 15:17:33');

/*!40000 ALTER TABLE `channel_conf` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table opt_history_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `opt_history_log`;

CREATE TABLE `opt_history_log` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `loan_id` bigint(32) DEFAULT NULL COMMENT '提现单号',
  `channel_id` bigint(32) DEFAULT NULL COMMENT '渠道号',
  `opt_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)名称',
  `opt_enum_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)枚举值',
  `opt_user` varchar(64) DEFAULT NULL COMMENT '操作员',
  `opt_log_detail` text,
  `ext_data` text,
  `opt_result` bigint(2) DEFAULT NULL COMMENT '是否成功 1 成功 0 失败',
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COMMENT='操作记录日志';

LOCK TABLES `opt_history_log` WRITE;
/*!40000 ALTER TABLE `opt_history_log` DISABLE KEYS */;

INSERT INTO `opt_history_log` (`id`, `channel_order_number`, `credit_number`, `loan_id`, `channel_id`, `opt_name`, `opt_enum_name`, `opt_user`, `opt_log_detail`, `ext_data`, `opt_result`, `create_time`)
VALUES
	(1,'zz_order_15717513717','FM528602232821672885783940',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-04 19:24:40'),
	(2,'zz_order_15717513718','FM529132581611685876188556',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-05 10:08:26'),
	(3,'zz_order_15717513717','FM528602232821672885783940',274,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 14:33:35'),
	(4,'zz_order_15717513717','FM528602232821672885783940',274,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 14:53:23'),
	(5,'zz_order_15717513719','FM529312275521705035989397',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-05 15:15:38'),
	(6,'zz_order_15717513719','FM529312275521705035989397',NULL,159858,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-05 15:17:00'),
	(7,'zz_order_15717513719','FM529312275521705035989397',275,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 15:40:49'),
	(8,'zz_order_15717513719','FM529312275521705035989397',275,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 15:41:50'),
	(9,'zz_order_15717513719','FM529312275521705035989397',275,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 15:45:23'),
	(10,'zz_order_15717513719','FM529312275521705035989397',275,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-05 15:46:17'),
	(11,'zz_order_15717513111','FM529355749571724922421913',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-05 16:23:56'),
	(12,'zz_order_15717513112','FM530014297211744900393218',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-06 10:37:53'),
	(13,'zz_order_15717513720','FM529349763591710750380543',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-06 10:46:46'),
	(14,'zz_order_15717513720','FM529349763591710750380543',NULL,159858,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-06 11:50:37'),
	(15,'zz_order_15717513113','FM530058981461759308160858',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-06 11:52:29'),
	(16,'zz_order_15717513114','FM532605368371789649997007',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-09 10:36:29'),
	(17,'zz_order_15717513115','FM532616408501796218631143',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-09 10:54:52'),
	(18,'zz_order_15717513116','FM532616477451804465648458',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-09 10:59:42'),
	(19,'zz_order_15717513117','FM532616537341811153739328',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-09 11:00:40'),
	(20,'zz_order_15717513118','FM532621097611820141146039',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 11:02:08'),
	(21,'zz_order_15717513118','FM532621097611820141146039',278,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-09 11:30:35'),
	(22,'zz_order_15717513118','FM532621097611820141146039',278,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-09 14:17:25'),
	(23,'zz_order_15717513120','FM532739176481841270321606',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 14:19:08'),
	(24,'zz_order_15717513120','FM532739176481841270321606',279,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-09 14:26:08'),
	(25,'zz_order_15717513121','FM532774262461859967420265',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 15:18:56'),
	(26,'zz_order_15717513719','FM529312275521705035989397',275,159858,'审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-09 15:25:41'),
	(27,'zz_order_15717513122','FM532827331551864201934243',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 16:46:26'),
	(28,'zz_order_15717513124','FM532827361481873263413785',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 16:46:40'),
	(29,'zz_order_15717513128','FM532839323431913303998593',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-09 17:06:24'),
	(30,'zz_order_15717513128','FM532839323431913303998593',283,159858,'审批操作',NULL,NULL,'放款操作失败',NULL,0,'2019-09-10 11:17:27'),
	(31,'zz_order_15717513129','FM533523071741939902755620',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 12:05:28'),
	(32,'zz_order_15717513130','FM533630841361948260054061',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 15:05:18'),
	(33,'zz_order_15717513130','FM533630841361948260054061',284,159858,'放款操作',NULL,NULL,',放款操作失败',NULL,0,'2019-09-10 15:44:18'),
	(34,'zz_order_15717513130','FM533630841361948260054061',284,159858,'放款操作',NULL,NULL,',放款操作失败',NULL,0,'2019-09-10 15:44:19'),
	(35,'ZZ1909101511240011','FM533635268651953685774065',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 15:45:20'),
	(36,'zz_order_15717513131','FM533686127161977060635475',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 16:37:38'),
	(37,'zz_order_15717513132','FM533686955371988557441747',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 16:38:34'),
	(38,'zz_order_15717513132','FM533686955371988557441747',285,159858,'放款操作',NULL,NULL,',放款操作失败',NULL,0,'2019-09-10 17:02:44'),
	(39,'zz_order_15717513133','FM533708748961996958278961',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 17:17:30'),
	(40,'zz_order_15717513118','FM532621097611820141146039',278,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-10 17:17:39'),
	(41,'zz_order_15717513124','FM532827361481873263413785',282,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-10 17:18:10'),
	(42,'zz_order_15717513133','FM533708748961996958278961',287,159858,'放款操作',NULL,NULL,',放款操作成功',NULL,1,'2019-09-10 17:39:05'),
	(43,'zz_order_15717513134','FM533727054282002808401182',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-10 17:46:53'),
	(44,'zz_order_15717513104','FM534383743462010606312518',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-11 11:59:56'),
	(45,'zz_order_15717514100','FM534407516952037394786845',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-11 12:40:47'),
	(46,'zz_order_15717514100','FM534407516952037394786845',290,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-11 12:46:58'),
	(47,'zz_order_15717514100','FM534407516952037394786845',290,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-11 12:48:27'),
	(48,'zz_order_15717514100','FM534407516952037394786845',290,159858,'放款操作',NULL,NULL,',放款操作成功',NULL,1,'2019-09-11 12:54:38'),
	(49,'zz_order_15717514101','FM534494238122046719108642',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-11 15:04:12'),
	(50,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-11 15:16:39'),
	(51,'rong_order_no_13700001000','SP535365722902061881221183',NULL,333,'审批操作',NULL,NULL,'',NULL,1,'2019-09-12 15:21:12'),
	(52,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:43:05'),
	(53,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:44:19'),
	(54,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:49:21'),
	(55,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:52:17'),
	(56,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:53:07'),
	(57,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-12 16:59:41'),
	(58,'zz_order_13393691118','FM539557482072086609332900',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-17 11:44:42'),
	(59,'zz_order_13393691124','FM540415798652094926405538',NULL,159858,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-18 11:33:34'),
	(60,'zz_order_13393691125','FM540579978552100038266258',NULL,159858,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-18 16:07:14'),
	(61,'zz_order_13393691126','FM540672663732113299844580',NULL,159858,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-18 18:43:27'),
	(62,'zz_order_13493691126','FM540680605842129901997092',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 10:05:25'),
	(63,'zz_order_one13061673036','FM541241386122133809060579',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 10:29:27'),
	(64,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 11:27:57'),
	(65,'zz_order_15717514101','FM534494238122046719108642',291,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 11:29:40'),
	(66,'zz_order_13575458192','FM541288407132154026762969',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 11:49:17'),
	(67,'zz_order_18912723249','FM541368965832165184266347',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 14:02:26'),
	(68,'zz_order_one13061673036','FM541241386122133809060579',297,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 14:47:58'),
	(69,'zz_order_13575458192','FM541288407132154026762969',296,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 15:03:33'),
	(70,'zz_order_13575458192','FM541288407132154026762969',296,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 15:05:08'),
	(71,'zz_order_18912723249','FM541368965832165184266347',298,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 15:16:46'),
	(72,'zz_order_13575458192','FM541288407132154026762969',296,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-19 15:18:48'),
	(73,'zz_order_18912723249','FM541368965832165184266347',298,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-19 15:23:12'),
	(74,'zz_order_13538130049','FM541285324742140004447583',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 15:27:45'),
	(75,'zz_order_13023085786','FM541472545602179668976281',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 16:55:03'),
	(76,'zz_order_13207211068','FM541521673752193046212666',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-19 18:17:19'),
	(77,'zz_order_13207211068','FM541521673752193046212666',301,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-19 19:16:16'),
	(78,'c750feb09d5f11e984840242ac160003','SP474052151431382889467819',196,159846,'二次审批操作',NULL,NULL,'二次风控失败，未找到channelConf配置',NULL,0,'2019-09-19 19:46:41'),
	(79,'c750feb09d5f11e984840242ac160003','SP474052151431382889467819',196,159846,'二次审批操作',NULL,NULL,'二次风控失败，未找到channelConf配置',NULL,0,'2019-09-19 19:47:18'),
	(80,'c750feb09d5f11e984840242ac160003','SP474052151431382889467819',196,159846,'二次审批操作',NULL,NULL,'二次风控失败，未找到channelConf配置',NULL,0,'2019-09-19 19:48:57'),
	(81,'zz_order_13207211068','FM541521673752193046212666',301,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-19 19:52:37'),
	(82,'zz_order_one13061673036','FM541241386122133809060579',297,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-19 19:55:30'),
	(83,'zz_order_13207211069','FM542124157912218866885012',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-20 11:00:43'),
	(84,'zz_order_13207211069','FM542124157912218866885012',302,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 11:08:38'),
	(85,'zz_order_13207211070','FM542124749482228901218862',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 11:12:39'),
	(86,'zz_order_13207211071','FM542125036102235067615461',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 11:12:47'),
	(87,'zz_order_13207211071','FM542125036102235067615461',303,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 11:17:49'),
	(88,'zz_order_13207211070','FM542124749482228901218862',304,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 11:53:57'),
	(89,'zz_order_13207211075','FM542175080252245484920641',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 12:26:31'),
	(90,'zz_order_13207211076','FM542175357122256546116569',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 12:26:37'),
	(91,'zz_order_13207211077','FM542175537872260103303947',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 12:26:41'),
	(92,'zz_order_13207211075','FM542175080252245484920641',305,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 12:42:39'),
	(93,'zz_order_13207211076','FM542175357122256546116569',306,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 12:57:45'),
	(94,'zz_order_17057356268','FM542243579632271759655635',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 14:20:03'),
	(95,'zz_order_17057356268','FM542243579632271759655635',308,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 14:28:57'),
	(96,'zz_order_17057356269','FM542252051032286050070710',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 14:34:01'),
	(97,'zz_order_13207211077','FM542175537872260103303947',307,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 14:41:11'),
	(98,'zz_order_17057356269','FM542252051032286050070710',309,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 14:42:00'),
	(99,'zz_order_17057356269','FM542252051032286050070710',309,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 14:45:29'),
	(100,'zz_order_13777840524','FM542259497612292358092717',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 14:46:45'),
	(101,'zz_order_13777840525','FM542263211242306011363143',NULL,159858,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 14:54:20'),
	(102,'zz_order_13777840525','FM542263211242306011363143',310,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 15:03:41'),
	(103,'zz_order_13777840525','FM542263211242306011363143',310,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-20 16:11:24'),
	(104,'sg_order_13718436002','FM542317810282327839623735',NULL,159865,'审批操作',NULL,NULL,'审批失败',NULL,0,'2019-09-20 16:37:28'),
	(105,'zz_order_13551947417','FM542328854122345212767879',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-20 16:42:06'),
	(106,'sg_order_13718436003','FM542327968822339237707158',NULL,159865,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-20 16:42:49'),
	(107,'sg_order_13718436004','FM542331244402362610133414',NULL,159865,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-20 16:45:58'),
	(108,'zz_order_13562406815','FM542331099092350395425582',NULL,159858,'审批操作',NULL,NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-20 16:46:36'),
	(109,'zz_order_13562406815','FM542331099092350395425582',311,159858,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 16:57:30'),
	(110,'sg_order_13718436004','FM542331244402362610133414',312,159865,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 16:58:27'),
	(111,'zz_order_13562406815','FM542331099092350395425582',311,159858,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-20 17:01:14'),
	(112,'sg_order_13718436005','FM542340079832377616975518',NULL,159865,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 17:01:29'),
	(113,'sg_order_13718436004','FM542331244402362610133414',312,159865,'放款操作',NULL,NULL,'放款操作成功',NULL,1,'2019-09-20 17:07:53'),
	(114,'sg_order_13718436005','FM542340079832377616975518',313,159865,'二次审批操作',NULL,NULL,'二次风控操作成功',NULL,1,'2019-09-20 17:10:46'),
	(115,'sg_order_13718436006','FM542341479042382208445849',NULL,159865,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 17:12:33'),
	(116,'sg_order_13718436007','FM542341550102396189640323',NULL,159865,'审批操作',NULL,NULL,'',NULL,1,'2019-09-20 17:12:39'),
	(117,'sg_order_13718436008','FM542341604062404231842186',NULL,159865,'审批操作','3',NULL,'',NULL,1,'2019-09-20 17:12:44'),
	(118,'sg_order_13718436006','FM542341479042382208445849',314,159865,'二次审批操作','4',NULL,'二次风控操作成功',NULL,1,'2019-09-20 17:26:34'),
	(119,'sg_order_13718436007','FM542341550102396189640323',315,159865,'二次审批操作','4',NULL,'二次风控操作成功',NULL,1,'2019-09-20 17:28:12'),
	(120,'sg_order_13718436008','FM542341604062404231842186',316,159865,'二次审批操作','4',NULL,'二次风控操作成功',NULL,1,'2019-09-20 17:33:47'),
	(121,'sg_order_13718436008','FM542341604062404231842186',316,159865,'放款操作','5',NULL,'放款操作成功',NULL,1,'2019-09-20 17:36:30'),
	(122,'sg_order_13718436006','FM542341479042382208445849',314,159865,'放款操作','5',NULL,'放款操作成功',NULL,1,'2019-09-20 17:36:38'),
	(123,'sg_order_13718436009','FM542369907072416485407615',NULL,159865,'审批操作','3',NULL,'',NULL,1,'2019-09-20 17:50:22'),
	(124,'sg_order_13718436010','FM542370073832421813662081',NULL,159865,'审批操作','3',NULL,'',NULL,1,'2019-09-20 17:51:09'),
	(125,'zz_order_13318907473','FM542412569532430551889111',NULL,159858,'审批操作','3',NULL,'',NULL,1,'2019-09-20 19:01:33'),
	(126,'zz_order_1331890747301','FM542424963232433363048950',NULL,159858,'审批操作','3',NULL,'',NULL,1,'2019-09-20 19:22:03'),
	(127,'zz_order_1331890747301','FM542424963232433363048950',317,159858,'二次审批操作','4',NULL,'二次风控操作成功',NULL,1,'2019-09-20 19:27:13'),
	(128,'zz_order_1331890747302','FM542431034542433211168064',NULL,159858,'审批操作','3',NULL,'',NULL,1,'2019-09-20 19:32:11'),
	(129,'sg_order_13718436011','FM544685870222440538445775',NULL,159865,'审批操作','3',NULL,'审批失败',NULL,0,'2019-09-23 11:03:00'),
	(130,'sg_order_13718436011','FM544685870222440538445775',NULL,159865,'审批操作','3',NULL,'审批失败',NULL,0,'2019-09-23 11:09:36'),
	(131,'sg_order_13718436011','FM544685870222440538445775',NULL,159865,'审批操作','3',NULL,'审批失败',NULL,0,'2019-09-23 11:10:10'),
	(132,'sg_order_13718436011','FM544685870222440538445775',NULL,159865,'审批操作','3',NULL,'资产计划未配置，请联系管理员配置',NULL,1,'2019-09-23 11:47:16');

/*!40000 ALTER TABLE `opt_history_log` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table order_approve
# ------------------------------------------------------------

DROP TABLE IF EXISTS `order_approve`;

CREATE TABLE `order_approve` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `channel_id` bigint(32) NOT NULL COMMENT '渠道号',
  `fund_id` bigint(16) DEFAULT NULL COMMENT '资方id',
  `fund_type` bigint(2) DEFAULT NULL COMMENT '资方类型0：非存管；1：存管',
  `ext_data` text,
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;

LOCK TABLES `order_approve` WRITE;
/*!40000 ALTER TABLE `order_approve` DISABLE KEYS */;

INSERT INTO `order_approve` (`id`, `channel_order_number`, `credit_number`, `channel_id`, `fund_id`, `fund_type`, `ext_data`, `create_time`, `update_time`)
VALUES
	(1,'zz_order_15717513785','FM521534919921309566324790',159858,630,1,NULL,'2019-08-28 16:14:20','2019-08-28 16:14:20'),
	(2,'zz_order_15717513784','FM521533785621297839879574',159858,630,1,NULL,'2019-08-28 17:11:02','2019-08-28 17:11:02'),
	(3,'256932251238047','FM520531495241211328473646',159865,630,1,NULL,'2019-08-28 17:24:55','2019-08-28 17:24:55'),
	(4,'zz_order_15717513782','FM521409210731279817044442',159858,630,1,NULL,'2019-08-28 17:27:38','2019-08-28 17:27:38'),
	(5,'zz_order_15717513783','FM521532446261286759492702',159858,630,1,NULL,'2019-08-28 17:31:37','2019-08-28 17:31:37'),
	(6,'zz_order_15717513775','FM518093278991132598122507',159858,630,1,NULL,'2019-08-28 18:21:52','2019-08-28 18:21:52'),
	(7,'ZZ1908261826170036','FM520791785963614291139370',159858,630,1,NULL,'2019-08-28 18:32:15','2019-08-28 18:32:15'),
	(8,'zz_order_13711112222','FM523360809991411879478082',159858,800,1,NULL,'2019-08-29 17:50:28','2019-08-29 17:50:28'),
	(9,'zz_order_15717513734','FM526693330711532987470587',159858,800,1,NULL,'2019-09-02 14:50:41','2019-09-02 14:50:41'),
	(10,'zz_order_15717513755','FM526714194371551176874603',159858,800,1,NULL,'2019-09-02 15:04:39','2019-09-02 15:04:39'),
	(11,'zz_order_15717513721','FM526769687201563782434548',159858,540,0,NULL,'2019-09-03 11:01:03','2019-09-03 11:01:03'),
	(12,'zz_order_15717513754','FM523981754251489809626091',159858,800,1,NULL,'2019-09-03 11:30:53','2019-09-03 11:30:53'),
	(13,'zz_order_15717513732','FM526593136911513713181711',159858,800,1,NULL,'2019-09-03 11:31:12','2019-09-03 11:31:12'),
	(14,'zz_order_15717513711','FM527549202341589131804299',159858,800,1,NULL,'2019-09-03 14:09:45','2019-09-03 14:09:45'),
	(15,'zz_order_15717513712','FM527550244121597043591869',159858,800,1,NULL,'2019-09-03 14:10:46','2019-09-03 14:10:46'),
	(16,'zz_order_15717513731','FM526587060141505929397692',159858,800,1,NULL,'2019-09-03 14:35:25','2019-09-03 14:35:25'),
	(17,'256932251238046','FM520525387711200054227061',159865,630,1,NULL,'2019-09-03 14:35:54','2019-09-03 14:35:54'),
	(18,'sg_order_13010001010','FM520500819271194059108357',159865,630,1,NULL,'2019-09-03 14:37:03','2019-09-03 14:37:03'),
	(19,'sg_order_13010001009','FM520500467671181464255707',159865,630,1,NULL,'2019-09-03 14:37:16','2019-09-03 14:37:16'),
	(20,'zz_order_15717513781','FM520714993491249035136360',159858,800,1,NULL,'2019-09-03 14:37:35','2019-09-03 14:37:35'),
	(21,'256932251238053','FM520745723111253046581801',159865,630,1,NULL,'2019-09-03 14:38:01','2019-09-03 14:38:01'),
	(22,'zz_order_15717513713','FM527552718021602386675425',159858,800,1,NULL,'2019-09-03 16:55:01','2019-09-03 16:55:01'),
	(23,'zz_order_15717513714','FM527662500631623786698892',159858,480,1,NULL,'2019-09-03 17:18:46','2019-09-03 17:18:46'),
	(24,'256932251238039','SP517340093931078598309657',159865,630,1,NULL,'2019-09-03 17:25:16','2019-09-03 17:25:16'),
	(25,'ZZ1908221432350020','FM517195241721001550538751',159858,480,1,NULL,'2019-09-03 17:25:22','2019-09-03 17:25:22'),
	(26,'ZZ1908221125370012','FM517083514099530796155236',159858,480,1,NULL,'2019-09-03 17:25:28','2019-09-03 17:25:28'),
	(27,'ZZ1908221110460011','FM517074535993758102003620',159858,480,1,NULL,'2019-09-03 17:25:32','2019-09-03 17:25:32'),
	(28,'ZZ1908221154180014','FM517100680101056581713580',159858,480,1,NULL,'2019-09-03 17:25:44','2019-09-03 17:25:44'),
	(29,'ZZ1908211820220001','FM516472842351008790035757',159858,480,1,NULL,'2019-09-03 17:25:47','2019-09-03 17:25:47'),
	(30,'zz_order_15717513715','FM528557501801642990886785',159858,800,1,NULL,'2019-09-04 18:09:40','2019-09-04 18:09:40'),
	(31,'zz_order_15717513715','FM528557501801642990886785',159858,800,1,NULL,'2019-09-04 18:10:44','2019-09-04 18:10:44'),
	(32,'zz_order_15717513715','FM528557501801642990886785',159858,800,1,NULL,'2019-09-04 18:12:57','2019-09-04 18:12:57'),
	(33,'256932251238041','SP517927747181092212847075',159865,630,1,NULL,'2019-09-04 18:17:44','2019-09-04 18:17:44'),
	(34,'256932251238040','SP517921537741088584780468',159865,630,1,NULL,'2019-09-04 18:19:52','2019-09-04 18:19:52'),
	(35,'ZZ1907231611220060','FM491334861664726169777273',159858,800,1,NULL,'2019-09-04 18:22:12','2019-09-04 18:22:12'),
	(36,'ZZ1908201040520034','FM515331894389556250077998',159858,800,1,NULL,'2019-09-04 18:27:40','2019-09-04 18:27:40'),
	(37,'ZZ1907151446230075','FM484372203433551247067856',159858,800,1,NULL,'2019-09-04 18:30:39','2019-09-04 18:30:39'),
	(38,'zz_order_15717513716','FM528574914911666852235581',159858,800,1,NULL,'2019-09-04 19:17:47','2019-09-04 19:17:47'),
	(39,'zz_order_15717513716','FM528574914911666852235581',159858,800,1,NULL,'2019-09-04 19:18:37','2019-09-04 19:18:37'),
	(40,'zz_order_15717513717','FM528602232821672885783940',159858,540,1,NULL,'2019-09-04 19:24:40','2019-09-04 19:24:40'),
	(41,'zz_order_15717513718','FM529132581611685876188556',159858,800,1,NULL,'2019-09-05 10:08:26','2019-09-05 10:08:26'),
	(47,'zz_order_15717513719','FM529312275521705035989397',159858,800,0,NULL,'2019-09-05 15:32:09','2019-09-05 15:32:09'),
	(48,'zz_order_15717513111','FM529355749571724922421913',159858,540,1,NULL,'2019-09-05 16:23:56','2019-09-05 16:23:56'),
	(49,'zz_order_15717513112','FM530014297211744900393218',159858,800,1,NULL,'2019-09-06 10:37:52','2019-09-06 10:37:52'),
	(50,'zz_order_15717513720','FM529349763591710750380543',159858,800,0,NULL,'2019-09-06 10:44:47','2019-09-06 11:50:37'),
	(51,'zz_order_15717513113','FM530058981461759308160858',159858,800,0,NULL,'2019-09-06 11:52:09','2019-09-06 11:52:09'),
	(52,'zz_order_15717513114','FM532605368371789649997007',159858,540,1,NULL,'2019-09-09 10:36:28','2019-09-09 10:36:28'),
	(53,'zz_order_15717513115','FM532616408501796218631143',159858,540,1,NULL,'2019-09-09 10:54:52','2019-09-09 10:54:52'),
	(54,'zz_order_15717513116','FM532616477451804465648458',159858,540,1,NULL,'2019-09-09 10:59:42','2019-09-09 10:59:42'),
	(55,'zz_order_15717513117','FM532616537341811153739328',159858,540,1,NULL,'2019-09-09 11:00:40','2019-09-09 11:00:40'),
	(56,'zz_order_15717513118','FM532621097611820141146039',159858,480,0,NULL,'2019-09-09 11:02:08','2019-09-09 11:02:08'),
	(57,'zz_order_15717513120','FM532739176481841270321606',159858,480,0,NULL,'2019-09-09 14:19:08','2019-09-09 14:19:08'),
	(58,'zz_order_15717513121','FM532774262461859967420265',159858,480,0,NULL,'2019-09-09 15:18:56','2019-09-09 15:18:56'),
	(59,'zz_order_15717513122','FM532827331551864201934243',159858,480,0,NULL,'2019-09-09 16:46:26','2019-09-09 16:46:26'),
	(60,'zz_order_15717513124','FM532827361481873263413785',159858,480,0,NULL,'2019-09-09 16:46:39','2019-09-09 16:46:39'),
	(61,'zz_order_15717513128','FM532839323431913303998593',159858,480,0,NULL,'2019-09-09 17:06:24','2019-09-09 17:06:24'),
	(62,'zz_order_15717513129','FM533523071741939902755620',159858,480,0,NULL,'2019-09-10 12:05:28','2019-09-10 12:05:28'),
	(63,'zz_order_15717513130','FM533630841361948260054061',159858,480,0,NULL,'2019-09-10 15:05:18','2019-09-10 15:05:18'),
	(64,'ZZ1909101511240011','FM533635268651953685774065',159858,480,0,NULL,'2019-09-10 15:45:20','2019-09-10 15:45:20'),
	(65,'zz_order_15717513131','FM533686127161977060635475',159858,480,0,NULL,'2019-09-10 16:37:37','2019-09-10 16:37:37'),
	(66,'zz_order_15717513132','FM533686955371988557441747',159858,480,0,NULL,'2019-09-10 16:38:34','2019-09-10 16:38:34'),
	(67,'zz_order_15717513133','FM533708748961996958278961',159858,480,0,NULL,'2019-09-10 17:17:30','2019-09-10 17:17:30'),
	(68,'zz_order_15717513134','FM533727054282002808401182',159858,540,1,NULL,'2019-09-10 17:46:52','2019-09-10 17:46:52'),
	(69,'zz_order_15717513104','FM534383743462010606312518',159858,540,1,NULL,'2019-09-11 11:59:56','2019-09-11 11:59:56'),
	(70,'zz_order_15717514100','FM534407516952037394786845',159858,800,0,NULL,'2019-09-11 12:40:47','2019-09-11 12:40:47'),
	(71,'zz_order_15717514101','FM534494238122046719108642',159858,800,0,NULL,'2019-09-11 15:04:12','2019-09-11 15:04:12'),
	(72,'rong_order_no_13700001000','SP535365722902061881221183',333,540,1,NULL,'2019-09-12 15:21:11','2019-09-12 15:21:11'),
	(73,'zz_order_13393691118','FM539557482072086609332900',159858,800,0,NULL,'2019-09-17 11:44:42','2019-09-17 11:44:42'),
	(74,'zz_order_13393691124','FM540415798652094926405538',159858,480,0,NULL,'2019-09-18 11:33:34','2019-09-18 11:33:34'),
	(75,'zz_order_13393691125','FM540579978552100038266258',159858,480,0,NULL,'2019-09-18 16:07:14','2019-09-18 16:07:14'),
	(76,'zz_order_13393691126','FM540672663732113299844580',159858,800,0,NULL,'2019-09-18 18:43:27','2019-09-18 18:43:27'),
	(77,'zz_order_13493691126','FM540680605842129901997092',159858,800,0,NULL,'2019-09-19 10:05:25','2019-09-19 10:05:25'),
	(78,'zz_order_one13061673036','FM541241386122133809060579',159858,800,0,NULL,'2019-09-19 10:29:27','2019-09-19 10:29:27'),
	(79,'zz_order_13575458192','FM541288407132154026762969',159858,800,0,NULL,'2019-09-19 11:49:17','2019-09-19 11:49:17'),
	(80,'zz_order_18912723249','FM541368965832165184266347',159858,800,0,NULL,'2019-09-19 14:02:26','2019-09-19 14:02:26'),
	(81,'zz_order_13538130049','FM541285324742140004447583',159858,800,0,NULL,'2019-09-19 15:27:45','2019-09-19 15:27:45'),
	(82,'zz_order_13023085786','FM541472545602179668976281',159858,800,0,NULL,'2019-09-19 16:55:02','2019-09-19 16:55:02'),
	(83,'zz_order_13207211068','FM541521673752193046212666',159858,800,0,NULL,'2019-09-19 18:17:18','2019-09-19 18:17:18'),
	(84,'zz_order_13207211069','FM542124157912218866885012',159858,800,0,NULL,'2019-09-20 11:00:42','2019-09-20 11:00:42'),
	(85,'zz_order_13207211070','FM542124749482228901218862',159858,800,0,NULL,'2019-09-20 11:12:39','2019-09-20 11:12:39'),
	(86,'zz_order_13207211071','FM542125036102235067615461',159858,800,0,NULL,'2019-09-20 11:12:47','2019-09-20 11:12:47'),
	(87,'zz_order_13207211075','FM542175080252245484920641',159858,800,0,NULL,'2019-09-20 12:26:31','2019-09-20 12:26:31'),
	(88,'zz_order_13207211076','FM542175357122256546116569',159858,800,0,NULL,'2019-09-20 12:26:37','2019-09-20 12:26:37'),
	(89,'zz_order_13207211077','FM542175537872260103303947',159858,800,0,NULL,'2019-09-20 12:26:41','2019-09-20 12:26:41'),
	(90,'zz_order_17057356268','FM542243579632271759655635',159858,800,0,NULL,'2019-09-20 14:20:03','2019-09-20 14:20:03'),
	(91,'zz_order_17057356269','FM542252051032286050070710',159858,800,0,NULL,'2019-09-20 14:34:00','2019-09-20 14:34:00'),
	(92,'zz_order_13777840524','FM542259497612292358092717',159858,800,0,NULL,'2019-09-20 14:46:45','2019-09-20 14:46:45'),
	(93,'zz_order_13777840525','FM542263211242306011363143',159858,800,0,NULL,'2019-09-20 14:54:20','2019-09-20 14:54:20'),
	(94,'sg_order_13718436002','FM542317810282327839623735',159865,800,0,NULL,'2019-09-20 16:37:28','2019-09-20 16:37:28'),
	(95,'zz_order_13551947417','FM542328854122345212767879',159858,800,0,NULL,'2019-09-20 16:42:06','2019-09-20 16:42:06'),
	(96,'sg_order_13718436003','FM542327968822339237707158',159865,800,0,NULL,'2019-09-20 16:42:49','2019-09-20 16:42:49'),
	(97,'sg_order_13718436004','FM542331244402362610133414',159865,480,0,NULL,'2019-09-20 16:45:57','2019-09-20 16:45:57'),
	(98,'zz_order_13562406815','FM542331099092350395425582',159858,800,0,NULL,'2019-09-20 16:46:36','2019-09-20 16:46:36'),
	(99,'sg_order_13718436005','FM542340079832377616975518',159865,480,0,NULL,'2019-09-20 17:01:29','2019-09-20 17:01:29'),
	(100,'sg_order_13718436006','FM542341479042382208445849',159865,480,0,NULL,'2019-09-20 17:12:33','2019-09-20 17:12:33'),
	(101,'sg_order_13718436007','FM542341550102396189640323',159865,480,0,NULL,'2019-09-20 17:12:38','2019-09-20 17:12:38'),
	(102,'sg_order_13718436008','FM542341604062404231842186',159865,480,0,NULL,'2019-09-20 17:12:44','2019-09-20 17:12:44'),
	(103,'sg_order_13718436009','FM542369907072416485407615',159865,480,0,NULL,'2019-09-20 17:50:22','2019-09-20 17:50:22'),
	(104,'sg_order_13718436010','FM542370073832421813662081',159865,480,0,NULL,'2019-09-20 17:51:09','2019-09-20 17:51:09'),
	(105,'zz_order_13318907473','FM542412569532430551889111',159858,800,0,NULL,'2019-09-20 19:01:32','2019-09-20 19:01:32'),
	(106,'zz_order_1331890747301','FM542424963232433363048950',159858,800,0,NULL,'2019-09-20 19:22:03','2019-09-20 19:22:03'),
	(107,'zz_order_1331890747302','FM542431034542433211168064',159858,800,0,NULL,'2019-09-20 19:32:10','2019-09-20 19:32:10'),
	(108,'sg_order_13718436011','FM544685870222440538445775',159865,630,9,NULL,'2019-09-23 11:02:59','2019-09-23 11:47:15');

/*!40000 ALTER TABLE `order_approve` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table permission
# ------------------------------------------------------------

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `desc` varchar(256) NOT NULL,
  `authorities` varchar(256) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

LOCK TABLES `permission` WRITE;
/*!40000 ALTER TABLE `permission` DISABLE KEYS */;

INSERT INTO `permission` (`id`, `name`, `desc`, `authorities`)
VALUES
	(1,'Log.logout','退出',''),
	(2,'Log.1','登陆操作1',''),
	(3,'Channel.getChannelList','查询渠道列表',''),
	(4,'Channel.getChannelConfInfo','查询单个渠道详细',''),
	(5,'Channel.editChannelConfInfo','编辑单个渠道详细',''),
	(6,'Channel.delete','删除渠道',''),
	(7,'Channel.back1','渠道操作占位1',''),
	(8,'Channel.back2','渠道操作占位2',''),
	(9,'User.addUser','添加用户',''),
	(10,'User.delete','删除用户',''),
	(11,'User.list','查询用户列表',''),
	(12,'User.disable','禁用用户',''),
	(13,'User.enable','启用用户',''),
	(14,'User.Order.cleanUserOrder','清除用户活跃订单',''),
	(15,'User.Order.cleanUserInfo','清除用户在xyqbUser信息',''),
	(16,'User.back1','用户操作占位1',''),
	(17,'User.back2','用户操作占位2',''),
	(18,'User.back2','用户操作占位2',''),
	(19,'Role.roleList','查询角色列表',''),
	(20,'Role.delete','删除角色',''),
	(21,'Role.saveRole','修改保存角色',''),
	(22,'Role.back1','角色占位1',''),
	(23,'Role.back2','角色占位2',''),
	(24,'Role.back3','角色占位3',''),
	(25,'Permission.outOfRolePermission','权限.查询用户未拥有的权限',''),
	(26,'Permission.permissionList','权限.查询所有权限',''),
	(27,'Permission.savePermission','新增修改权限',''),
	(28,'Permission.delete','删除某个权限',''),
	(29,'Permission.1','权限操作占位1',''),
	(30,'Permission.2','权限操作占位2',''),
	(31,'Order.getOrderHistoryStatus','查询历史订单状态',''),
	(32,'Order.orderCallbackRecordList','查询订单推送记录',''),
	(33,'Order.secondAudit','订单二次风控审批',''),
	(34,'Order.loadSecondAuditJob','刷新待放款定时任务',''),
	(35,'Order.getOrderList','查询订单列表',''),
	(36,'Order.approveOpt','订单审批',''),
	(37,'Order.lending','订单放款',''),
	(38,'Order.cancelPreLoan','贷前关单',''),
	(39,'Order.cancelAfterLoan','贷后关单','');

/*!40000 ALTER TABLE `permission` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table role
# ------------------------------------------------------------

DROP TABLE IF EXISTS `role`;

CREATE TABLE `role` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `parent_id` int(20) DEFAULT NULL COMMENT '父角色ID',
  `name` varchar(32) NOT NULL COMMENT '角色名称',
  `desc` varchar(128) NOT NULL DEFAULT '' COMMENT '角色描述',
  `max_rank` varchar(128) NOT NULL DEFAULT '' COMMENT '最大rank',
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;

INSERT INTO `role` (`id`, `parent_id`, `name`, `desc`, `max_rank`, `create_time`, `update_time`)
VALUES
	(1,NULL,'admin','系统维护管理员','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(2,NULL,'量化派操作员','除了添加权限 和 角色 之外都有权限','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(3,NULL,'总渠道','拥有查询，和订单操作权限','','2019-08-06 13:31:37','2019-08-06 13:31:37'),
	(4,3,'普通渠道','普通渠道','','2019-08-06 13:31:37','2019-08-06 13:31:37'),
	(5,NULL,'量化派查询角色','查询 权限','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(6,5,'量化派产品','产品角色','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(7,5,'量化派运营','运营角色','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(8,2,'量化派测试','量化派测试','','2019-08-06 13:31:26','2019-08-06 13:31:26');

/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table role_permission_mapping
# ------------------------------------------------------------

DROP TABLE IF EXISTS `role_permission_mapping`;

CREATE TABLE `role_permission_mapping` (
  `role_id` bigint(20) NOT NULL,
  `permission_id` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

LOCK TABLES `role_permission_mapping` WRITE;
/*!40000 ALTER TABLE `role_permission_mapping` DISABLE KEYS */;

INSERT INTO `role_permission_mapping` (`role_id`, `permission_id`)
VALUES
	(2,1),
	(2,2),
	(2,3),
	(2,4),
	(2,5),
	(2,6),
	(2,7),
	(2,8),
	(2,9),
	(2,10),
	(2,11),
	(2,12),
	(2,13),
	(2,14),
	(2,15),
	(2,16),
	(2,17),
	(2,18),
	(2,31),
	(2,32),
	(2,33),
	(2,34),
	(2,35),
	(2,36),
	(2,37),
	(2,38),
	(2,39),
	(3,1),
	(3,2),
	(3,3),
	(3,4),
	(3,5),
	(3,7),
	(3,8),
	(3,14),
	(3,15),
	(3,16),
	(3,17),
	(3,18),
	(3,31),
	(3,32),
	(3,33),
	(3,34),
	(3,35),
	(3,36),
	(3,37),
	(3,38),
	(3,39),
	(5,1),
	(5,2),
	(5,3),
	(5,4),
	(5,7),
	(5,8),
	(5,31),
	(5,32),
	(5,35),
	(9,1),
	(9,2),
	(9,3),
	(9,4),
	(9,5),
	(9,6),
	(9,7),
	(9,8),
	(9,9),
	(9,10),
	(9,11),
	(9,12),
	(9,13),
	(9,14),
	(9,15),
	(9,16),
	(9,17),
	(9,18),
	(9,31),
	(9,32),
	(9,33),
	(9,34),
	(9,35),
	(9,36),
	(9,37),
	(9,38),
	(9,39);

/*!40000 ALTER TABLE `role_permission_mapping` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `nickname` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL,
  `channel_id` int(11) DEFAULT NULL COMMENT '渠道ID',
  `rank` varchar(64) NOT NULL COMMENT '用户级别',
  `status` varchar(10) DEFAULT NULL,
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  `last_login_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;

INSERT INTO `user` (`id`, `username`, `nickname`, `password`, `channel_id`, `rank`, `status`, `create_time`, `update_time`, `last_login_time`)
VALUES
	(1,'admin','帝释天','81DC9BDB52D04DC20036DBD8313ED055',NULL,'SUPER_ADMINISTRATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(2,'admin01','超级boss','81DC9BDB52D04DC20036DBD8313ED055',NULL,'SUPER_ADMINISTRATOR','ENABLED','2019-08-06 13:33:15','2019-08-06 13:33:15','2019-08-06 13:33:15'),
	(3,'yqg01','洋钱罐','202CB962AC59075B964B07152D234B70',159766,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(4,'qiancheng','浅橙','202CB962AC59075B964B07152D234B70',159507,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(5,'zhangzhong','掌众','202CB962AC59075B964B07152D234B70',159858,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(6,'shiguang','时光分期','202CB962AC59075B964B07152D234B70',159865,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(7,'pm01','量化派产品0','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(8,'pm02','量化派产品1','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(9,'yunying','运营1','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:03:57','2019-09-19 18:03:57',NULL),
	(10,'yunying2','运营2','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL),
	(11,'huhui','胡慧','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL),
	(12,'suntao','suntao','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL);

/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table user_role_mapping
# ------------------------------------------------------------

DROP TABLE IF EXISTS `user_role_mapping`;

CREATE TABLE `user_role_mapping` (
  `user_id` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `role_id` varchar(255) COLLATE utf8_bin NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

LOCK TABLES `user_role_mapping` WRITE;
/*!40000 ALTER TABLE `user_role_mapping` DISABLE KEYS */;

INSERT INTO `user_role_mapping` (`user_id`, `role_id`)
VALUES
	('1','1'),
	('2','1'),
	('3','4'),
	('4','4'),
	('5','4'),
	('6','4'),
	('7','6'),
	('8','6'),
	('9','6'),
	('10','6'),
	('11','8'),
	('12','2');

/*!40000 ALTER TABLE `user_role_mapping` ENABLE KEYS */;
UNLOCK TABLES;



/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
