package cn.quantgroup.cashloanflowboss.service.contract;

import cn.quantgroup.cashloanflowboss.CashLoanFlowBossApplicationTests;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.api.channel.service.ChannelConfService;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ChannelApplyInfoStrategy;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * function:
 * date: 2019/12/6
 *
 * @author: suntao
 */
public class ChannelApplyInfoStrategyTest extends CashLoanFlowBossApplicationTests {

    @Autowired
    private CLFCenterService clfCenterService;

    @Autowired
    private ChannelConfService channelConfService;

    @Test
    public void test() {
        ChannelApplyInfoStrategy strategy = new ChannelApplyInfoStrategy();
        strategy.setAddress(true);
        strategy.setChannelId(12L);
        strategy.setChannelName("测试");
        strategy.setContact(false);
        strategy.setChannelUserId(false);
        strategy.setContactsBook(true);
        strategy.setDevice(true);
        strategy.setEducation(true);
        strategy.setEmail(false);
        strategy.setIncome(true);
        strategy.setMobile(true);
        clfCenterService.saveChannelApplyInfoStrategy(strategy);

        ChannelApplyInfoStrategy strategy1 = clfCenterService.findChannelApplyInfoStrategyByChannelId(12L);

        strategy.setId(strategy1.getId());
        strategy.setChannelName("测试更新");
        clfCenterService.saveChannelApplyInfoStrategy(strategy);
    }

    @Test
    public void testGetChannelInfo(){
        ChannelConfVo channelConf = channelConfService.getChannelConf(159881L);

        ChannelApplyInfoStrategy channelApplyInfoStrategy = channelConf.getBasicInfo().getChannelApplyInfoStrategy();

        channelApplyInfoStrategy.setChannelUserId(true);
        channelConfService.editChannelConfInfo(channelConf);



    }
}
