//package cn.quantgroup.cashloanflowboss.core.configuration.job;
//
//import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickJobConfig;
//import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickJobConfigRepository;
//import cn.quantgroup.cashloanflowboss.core.Application;
//
//import com.dangdang.ddframe.job.api.ElasticJob;
//import com.dangdang.ddframe.job.api.simple.SimpleJob;
//import com.dangdang.ddframe.job.config.JobCoreConfiguration;
//import com.dangdang.ddframe.job.config.JobTypeConfiguration;
//import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
//import com.dangdang.ddframe.job.event.JobEventConfiguration;
//import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
//import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
//import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.CommandLineRunner;
//import org.springframework.stereotype.Component;
//
//import javax.annotation.Resource;
//import java.util.List;
//
//;
//
///**
// * 可以动态改变任务，（JobConfigUpdateController 提供接口）
// * Created with suntao on 2019/3/19
// */
//@Slf4j
//@Component
//public class ElasticJobLoader2 implements CommandLineRunner {
//
//    @Autowired
//    private OneClickJobConfigRepository oneClickJobConfigRepository;
//
//    @Resource
//    private ZookeeperRegistryCenter zookeeperRegistryCenter;
//
//    @Resource
//    private JobEventConfiguration jobEventConfiguration;
//
//
//
//    @Override
//    public void run(String... args) {
//        List<OneClickJobConfig> oneClickJobConfigList = oneClickJobConfigRepository.findAllActive();
//        if (oneClickJobConfigList == null || oneClickJobConfigList.size() == 0) {
//            return;
//        }
//        oneClickJobConfigList.forEach(oneClickJobConfig -> registryJob(oneClickJobConfig));
//        log.info("所有定时任务加载完成");
//    }
//
//
//    /**
//     * 重新加载任务
//     * @param ids
//     */
//    public void reloadJobByIds(List<Long> ids) {
//        List<OneClickJobConfig> oneClickJobConfigList = oneClickJobConfigRepository.findAll(ids);
//        oneClickJobConfigList.forEach(oneClickJobConfig -> registryJob(oneClickJobConfig));
//    }
//
//    private void registryJob(OneClickJobConfig oneClickJobConfigBean) {
//        try {
//            Class<? extends ElasticJob> jobClass = (Class<? extends ElasticJob>) Class
//                    .forName(oneClickJobConfigBean.getJobClass());
//            ElasticJob elasticJob = getInstance(jobClass);
//            SpringJobScheduler jobScheduler = jobScheduler(elasticJob, oneClickJobConfigBean);
//            jobScheduler.init();
//            log.info("初始化定时任务 {} ", oneClickJobConfigBean.toString());
//        } catch (Exception e) {
//            log.error("注册Job出错：{} ", oneClickJobConfigBean.toString(), e);
//        }
//
//    }
//
//
//    /**
//     * 通过反射对有@Resource和@Autowired的属性赋值
//     *
//     * @param jobClass
//     * @return
//     */
//    private ElasticJob getInstance(Class<? extends ElasticJob> jobClass) {
//        ElasticJob bean = Application.getBean(jobClass);
//        return bean;
//    }
//
//    /**
//     * 注册SpringJobScheduler
//     *
//     * @param elasticJob
//     * @param oneClickJobConfigBean
//     * @return
//     */
//    private SpringJobScheduler jobScheduler(ElasticJob elasticJob, OneClickJobConfig oneClickJobConfigBean) {
//        LiteJobConfiguration build = LiteJobConfiguration.newBuilder(jobConfiguration(elasticJob, oneClickJobConfigBean))
//                .overwrite(true).build();
//        SpringJobScheduler springJobScheduler = new SpringJobScheduler(elasticJob, zookeeperRegistryCenter, build,
//                jobEventConfiguration);
//        return springJobScheduler;
//    }
//
//    /**
//     * job配置
//     *
//     * @param elasticJob
//     * @param oneClickJobConfigBean
//     * @return
//     */
//    private JobTypeConfiguration jobConfiguration(final ElasticJob elasticJob,
//                                                  OneClickJobConfig oneClickJobConfigBean) {
//        JobCoreConfiguration jobCoreConfiguration = JobCoreConfiguration
//                .newBuilder(oneClickJobConfigBean.getJobName(), oneClickJobConfigBean.getCron(),
//                        oneClickJobConfigBean.getShardingTotalCount())
//                .shardingItemParameters(oneClickJobConfigBean.getShardingItemParameters())
//                .description(oneClickJobConfigBean.getDescription())
//                .jobParameter(oneClickJobConfigBean.getJobParameter())
//                .build();
//        if (elasticJob instanceof SimpleJob) {
//            return new SimpleJobConfiguration(jobCoreConfiguration, elasticJob.getClass().getCanonicalName());
//        }
//
//        throw new RuntimeException("未知类型定时任务：" + elasticJob.getClass().getName());
//    }
//
//
//}
