package cn.quantgroup.cashloanflowboss.spi.clf.model;


/**
 *  对应 MQ 消息通知类型 的枚举类，在数据库中保存，和QuotaNoticeType 独立，保证xyqb改动的灵活性
 * Created with suntao on 2018/4/15
 */
public enum KANoticeType {
    CREDIT_SUCC("CREDIT_SUCC", "授信成功"),//0
    CREDIT_FAIL("CREDIT_FAIL", "授信失败"),//1
    FUAD_ASSIFN_SUCC("FUAD_ASSIFN_SUCC", "分配资金方成功"),//2
    FUAD_ASSIFN_FAIL("FUAD_ASSIFN_FAIL", "分配资金方失败"),//3
    BIND_SUCC("BIND_SUCC", "绑卡成功"),//4
    BIND_FAIL("BIND_FAIL", "绑卡失败"),//5
    WAITING_FUND("WAITING_FUND", "进件给资金方成功，等待放款"),//6
    FUND_SUCC("FUND_SUCC", "放款成功"),//7
    FUND_WITHDRAW_SUCC("FUND_WITHDRAW_SUCC", "放款提现成功,存管提现成功"),//8
    FUND_FAIL("FUND_FAIL", "放款失败"),//9
    REPAYMENT("REPAYMENT", "还款成功"),//10
    ALL_REPAID("ALL_REPAID", "结清"),//11
    QUOTA_INCREASE("QUOTA_INCREASE", "额度提升"),//12
    QUOTA_DECREASE("QUOTA_DECREASE", "额度下降"),//13
    QUOTA_FREEZE("QUOTA_FREEZE", "风控额度冻结"),//14
    WITHDRAW("WITHDRAW", "用户提现额度冻结"),//WITHDRAW,创建loanId,//15(BIND_SUCC 同时发送)
    REJECT("REJECT", "风控审核不通过"),//16
    RISK_PASS("RISK_PASS", "风控审核通过"),//17
    INCREASE_CHANGE("INCREASE_CHANGE", "利率调整"),//18
    CANCEL_LOAN("CANCEL_LOAN", "关闭订单"),//19
    COMPENSATORY("COMPENSATORY", "代偿"),//20
    DROP_COURSE("DROP_COURSE", "退课代偿"),//21
    CANCEL_AFTER_LOAN("CANCEL_AFTER_LOAN", "贷后关闭订单"),//22
    ADD_CARD_SUCCESS("ADD_CARD_SUCCESS", "添加银行卡成功，非提现页面绑卡"), //23
    REPAY_FAIL("REPAY_FAIL", "还款失败"), //24


    APPROVE_ING("APPROVE_ING", "审批中"),
    PAY_ING("PAY_ING", "放款中"),
    WITHDRAW_APPROVING("WITHDRAW_APPROVING", "提现审批中"),  //对应loan状态50，等待二次审核
    FUND_WAITING_WITHDRAW("FUND_WAITING_WITHDRAW", "放款成功,等待二次提现"),

    UNKNOWN("UNKNOWN", "没有逻辑意义的数据库兼容的值"),
    RP_INIT_F_SUCC("REPAYMENT_INIT_FUND_SUCC", "放款成功推送还款计划"),
    TEST("TEST", "test");


    private String type;
    private String desc;

    KANoticeType(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static KANoticeType getOrdinalValue(Integer ordinal) {
        KANoticeType[] values = values();
        for (int i = 0; i < values.length; i++) {
            if (values[i].ordinal() == ordinal) {
                return values[i];
            }
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }


}
