package cn.quantgroup.cashloanflowboss.api.user.model;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;
import java.util.Set;

@Data
public class UserDetailInfo {
    private UserInfo userInfo;
    private RoleInfo roleInfo;
    private Long channelId;
    private String rank;


    @Data
    static class RoleInfo {
        List<roleView> roleInfos;

        @Data
        static class roleView {
            private Long roleId;
            private String roleName;
        }
    }

    @Data
    public static class UserInfo {
        private Long userId;
        private String userName;
        private String nickname;
    }

    public static UserDetailInfo valueOf(Principal principal, User user) {
        Assert.isNull(principal, ApplicationStatus.INVALID_USER);
        UserDetailInfo userDetailInfo = new UserDetailInfo();
        Long userId = principal.getUserId();
        userDetailInfo.setRank(principal.getRank().name());
        userDetailInfo.setChannelId(principal.getChannelId());
        List<Role> roles = principal.getRoles();

        if (null != roles && roles.size() > 0) {
            RoleInfo roleInfo = new RoleInfo();
            List<RoleInfo.roleView> roleInfos = Lists.newArrayList();
            roles.forEach(role -> {
                RoleInfo.roleView roleView = new RoleInfo.roleView();
                roleView.setRoleId(role.getId());
                roleView.setRoleName(role.getName());
                roleInfos.add(roleView);
            });
            roleInfo.setRoleInfos(roleInfos);
            userDetailInfo.setRoleInfo(roleInfo);
        }

        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(userId);
        userInfo.setNickname(user.getNickname());
        userInfo.setUserName(user.getUsername());
        userDetailInfo.setUserInfo(userInfo);

        return userDetailInfo;
    }


}
