package cn.quantgroup.cashloanflowboss.api.login.service;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.model.UserInfo;
import cn.quantgroup.cashloanflowboss.api.user.service.UserService;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Slf4j
@Service
public class LoginServiceImpl implements LoginService {

    @Autowired
    private UserService userService;

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private PrincipalService principalService;

    /**
     * 登入
     *
     * @param username 用户名
     * @param password 密码（明文）
     * @return
     */
    @Override
    public Tuple<ApplicationStatus, String> login(String username, String password) {

        User user = this.userService.getUser(username);

        // 检查用户是否有效
        if (user == null) {
            log.info("用户不存在username=" + username);
            return new Tuple<>(ApplicationStatus.INVALID_USER, "");
        }

        // 检查用户是否被禁用
        if (UserStatus.DISABLED.equals(user.getStatus())) {
            log.info("用户已禁用username=" + username);
            return new Tuple<>(ApplicationStatus.DISABLED_USER, "");
        }

        // 检查密码是否正确
        final String passwordMd5 = MD5Tools.md5(password);
        if (!user.getPassword().equalsIgnoreCase(passwordMd5)) {
            log.info("用户名或密码错误username=" + username);
            log.info("user.name:{},user.pwd:{},passwordMd5:{}", user.getUsername(), user.getPassword(), passwordMd5);
            return new Tuple<>(ApplicationStatus.USERNAME_OR_PASSWORD_ERROR, "");
        }

        // 创建Session
        HttpSession session = this.request.getSession(true);

        // 设置用户主要信息
        Principal principal = new Principal();
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(user.getId());
        userInfo.setUsername(user.getUsername());
        userInfo.setNickname(user.getNickname());

        principal.setUserInfo(userInfo);
        principal.setChannelId(user.getChannelId());
        principal.setRank(user.getRank());
        principal.setRoles(user.getRoles());
        long currentTimeMillis = System.currentTimeMillis();
        principal.setLoginTimeMillis(currentTimeMillis);

        String bossToken = Application.getBossToken(request);
        String token = StringUtils.isEmpty(bossToken) ? UUID.randomUUID().toString() : bossToken;
        principalService.pushPrincipal(token, principal);

//        stringRedisTemplate.opsForValue().set(principal.getUserInfo().getUsername(), token, 3, TimeUnit.HOURS);
//        session.setAttribute(ApplicationDictionary.PRINCIPAL, JSONTools.serialize(principal));
        // session登陆时间，毫秒值
        session.setAttribute(ApplicationDictionary.USER_SESSION_LOGIN_TIME, currentTimeMillis);

        // 保存用户最后登陆时间
        user.setLastLoginTime(new Date());
        userService.updateUser(user);
//        log.info("登陆成功sessionId="+ session.getId());
        return new Tuple<>(ApplicationStatus.SUCCESS, token);
    }

    /**
     * 登出
     *
     * @return
     */
    @Override
    public boolean logout() {
        principalService.removePrincipal();

        this.request.getSession().removeAttribute(ApplicationDictionary.PRINCIPAL);

        return true;

    }

}
