package cn.quantgroup.cashloanflowboss.core.configuration;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.component.security.SecurityHandler;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * Created by WeiWei on 2019/7/26.
 */
@Configuration
public class ApplicationSecurityHandler implements SecurityHandler {

    @Override
    public boolean doAuthentication(MethodInvocation invocation, String authorityId, Authority[] authority) throws Throwable {

        Principal principal = Application.getPrincipal();

        // 检查是否已登录
        Assert.isNull(principal, ApplicationStatus.AUTHENTICATION_FAILURE);

        // 如果是超级管理员跳过权限验证
        boolean superAdministrator = principal.isSuperAdministrator();

        boolean anyMatch = principal.getRoles().stream().anyMatch(role -> {
            List<Role> roleList = getRoleAndParent(role);
            return roleList.stream().anyMatch(_role -> this.checkAuthority(authorityId, _role));
        });
        return  superAdministrator || anyMatch;

    }

    private List<Role> getRoleAndParent(Role role) {
        if (role == null) {
            return new ArrayList<>();
        }

        List<Role> list = new ArrayList<>();
        list.add(role);

        while (role.getParent() != null) {
            role = role.getParent();
            list.add(role);
        }
        return list;
    }

    /**
     * 检查权限
     *
     * @param authorityId
     * @param role
     * @return
     */
    private boolean checkAuthority(String authorityId, Role role) {
        if (role == null) {
            return false;
        }
        return CollectionUtils.isNotEmpty(role.getPermissions()) && role.getPermissions().parallelStream().anyMatch(permission -> permission.getName().equals(authorityId));
    }

}
