package cn.quantgroup.cashloanflowboss.api.channel.controller;

import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelModel;
import cn.quantgroup.cashloanflowboss.api.channel.service.ChannelConfService;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.annotation.channelrole.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.annotation.channelrole.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Created with suntao on 2019/8/2
 *
 * @author suntao
 */
@RestController
@RequestMapping("channel")
public class ChannelConfController {


    @Autowired
    private ChannelConfService channelConfService;
    @Autowired
    private CLFCenterService clfCenterService;


    /**
     * 查询渠道列表，如果是渠道角色登陆，只能查询自己渠道
     *
     * @param channelId
     * @param pageNumber
     * @param pageSize
     * @return
     */
    @Security(authorityId = "Channel.getChannelList")
    @ChannelIdInit(channelIdSPEL = "#this[0]")
    @PostMapping("/info")
    public Result channelList(Long channelId, String channelName, Integer pageNumber, Integer pageSize) {
        if (pageNumber == null || pageSize == null) {
            return Result.buildFail("page信息不对");
        }
        return Result.buildSuccess(channelConfService.getChannelInfo(pageNumber, pageSize, channelId, channelName));
    }

    /**
     * 查询单个渠道配置
     * 如果是渠道用户，只能查自己，查询条件置灰
     * @param channelId
     * @return
     */
    @Security(authorityId = "Channel.getChannelConfInfo")
    @ChannelIdInit(channelIdSPEL = "#this[0]")
    @CheckChannelRole(channelIdSPEL = "#this[0]")
    @GetMapping("/cfg/info")
    public Result getChannelConfInfo(Long channelId) {
        return Result.buildSuccess(channelConfService.getChannelConf(channelId), "success");
    }


    /**
     * 修改渠道配置，如果是渠道角色登陆  只能修改自己渠道信息
     * @param channelConfVo
     * @return
     */
    @Security(authorityId = "Channel.editChannelConfInfo")
    @CheckChannelRole(channelIdSPEL = "#this[0].basicInfo.channelId")
    @PostMapping("/cfg/info")
    public Result editChannelConfInfo(@RequestBody @Valid ChannelConfVo channelConfVo) {
        Boolean aBoolean = channelConfService.editChannelConfInfo(channelConfVo);

        // TODO 检查渠道

        if (aBoolean) {
            // 属性ka缓存
            clfCenterService.reloadKAConfiguration();
        }

        return Result.buildSuccess(aBoolean ? "编辑修改成功" : "编辑修改失败");
    }


    @GetMapping("/all")
    public Result channelAll(){
        List<ChannelModel> all = channelConfService.getAll();
        return Result.buildSuccess(all);
    }


}
