package cn.quantgroup.cashloanflowboss.spi.clf.entity;


import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRouter;
import lombok.*;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * Created by liqing on 2017/5/5 0005.
 */
@Setter
@Getter
@Entity
@Table(name = "callback_configuration", catalog = "cash_loan_flow")
public class CallbackConfiguration implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "is_loan_makeup")
    private Boolean isLoanMakeup;

    @Column(name = "is_repay_makeup")
    private Boolean isRepayMakeup;

    @Column(name = "loan_makeup_strategy")
    private String loanMakeupStrategy;

    @Column(name = "repay_makeup_strategy")
    private String repayMakeupStrategy;

    @Column(name = "is_active")
    private Boolean isActive;

    @Column(name = "only_new_user")
    private Boolean onlyNewUser;

    @Column(name = "callback_service_name")
    private String callbackServiceName;

    @Column(name = "callback_no_push_progress")
    private String callbackNoPushProgress;

    @Column(name = "pre_progress")
    private String preProgress;

    @Column(name = "retry_max_times")
    private Long retryMaxTimes;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "callback_router")
    private CallbackRouter callbackRouter;

//    @Transient
//    private LoanMakeupStrategyModel loanMakeupStrategyModel;
//    @Transient
//    private RepayMakeupStrategyModel repayMakeupStrategyModel;
//
//    public void generateMakeupStrategyModel() {
//        if (StringUtils.isNotBlank(loanMakeupStrategy)) {
//            loanMakeupStrategyModel = Constants.GSON.fromJson(loanMakeupStrategy, LoanMakeupStrategyModel.class);
//        }
//        if (StringUtils.isNotBlank(repayMakeupStrategy)) {
//            repayMakeupStrategyModel = Constants.GSON.fromJson(repayMakeupStrategy, RepayMakeupStrategyModel.class);
//        }
//    }
//
//    public LoanMakeupStrategyModel getLoanMakeupStrategyModel() {
//        if (loanMakeupStrategyModel == null) {
//            loanMakeupStrategyModel = Constants.GSON.fromJson(loanMakeupStrategy, LoanMakeupStrategyModel.class);
//        }
//        return loanMakeupStrategyModel;
//    }
//
//    public RepayMakeupStrategyModel getRepayMakeupStrategyModel() {
//        if (repayMakeupStrategyModel == null) {
//            repayMakeupStrategyModel = Constants.GSON.fromJson(repayMakeupStrategy, RepayMakeupStrategyModel.class);
//        }
//        return repayMakeupStrategyModel;
//    }
//
//    @Setter
//    @Getter
//    @Builder
//    @NoArgsConstructor
//    @AllArgsConstructor
//    public static class LoanMakeupStrategyModel implements Serializable {
//        private static final long serialVersionUID = -1L;
//
//        private Map<Integer, Integer> preProgressMap; // 前一个应推送的状态映射
//        private Map<Integer, Integer> pushStatusMap; // 应推送的状态映射
//        private Set<Integer> allStatus; // 所有需要关注的状态
//        private Long hourAgo; // 关注hourAgo小时之内发生变更的状态
//        private Integer maxCount; // 最多一次补偿数量
//
//        public String toJson() {
//            return Constants.GSON.toJson(this);
//        }
//    }
//
//    @Setter
//    @Getter
//    @Builder
//    @NoArgsConstructor
//    @AllArgsConstructor
//    public static class RepayMakeupStrategyModel implements Serializable {
//        private static final long serialVersionUID = -1L;
//
//        private Long hourAgo; // 关注hourAgo小时之内发生收到的还款
//        private Integer maxCount; // 最多一次补偿数量
//
//        public String toJson() {
//            return Constants.GSON.toJson(this);
//        }
//    }
}
