package cn.quantgroup.cashloanflowboss.spi.paycenter.repository;

import cn.quantgroup.cashloanflowboss.spi.paycenter.entity.CardCheckRecordEntity;
import cn.quantgroup.cashloanflowboss.spi.paycenter.source.GuBeiDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

/**
 * 卡号效验表
 * @author wudi
 */
@GuBeiDataSource
@Repository
public interface ICardCheckRecordRepository extends JpaRepository<CardCheckRecordEntity, Long> {

    /**
     * 根据银行卡号获取卡信息
     * @param cardNo
     * @return
     */
    CardCheckRecordEntity findByCardNo(String cardNo);
    /**
     * 查询最后一条记录
     * @return
     */
    @Query(value = "select * from card_check_record order by id desc limit 1", nativeQuery = true)
    CardCheckRecordEntity findLastRecord();

}
