package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CashWithdrawalService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.LoanOperationService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.utils.*;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/18.
 */
@Slf4j
@Service
public class CashWithdrawalServiceImpl implements CashWithdrawalService{
    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CLFCenterServiceImpl clfCenterService;
    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private LoanOperationService loanOperationService;

    private ClfChannelConfiguration clfChannelConfiguration;
    private  String md5Keywy = "qEAxMJBv";
    private  String aesKeywy = "sxD8KO79EDK0N0AJ";
    /**
    *申请提现请求
    * */
    @Override
    public Result applyLoan(OneClickData oneClickData) {
        JSONObject result;
        //通过用户id获取产品信息
//        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(Long.valueOf(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
//        log.info("打印quotaCredit={}",quotaCredit);
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickData.getChannelCode().trim()));
        log.info("oneClickData={}",oneClickData);
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();

        if(oneClickData.getChannelCode().trim().equals(ChannelEnum.ZHANGHZONG.getCode())){
            result= applyZhangZhongLoan(oneClickData, md5Keywy, aesKeywy);

        }else if(oneClickData.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            result= null;
        }else if(oneClickData.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
            result= null;
        }else if(oneClickData.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
            result= null;
        }else if(oneClickData.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
            result= null;
        }else{
            result= null;
        }

        String getDecryption = AESUtil.decryptAfterBase64Decode(result.get("context").toString(), aesKeywy);
        log.info("解密的getDecryption的结果={}" + getDecryption);

        JSONObject getDecryptionResult = (JSONObject) JSONObject.parse(getDecryption);
        log.info("打印一下getDecryptionResult={}",getDecryptionResult.get("bizData"));
        JSONObject bizData= (JSONObject) JSONObject.parse(getDecryptionResult.get("bizData").toString());
        log.info("提现结果打印bizData={}",bizData);
        String code=bizData.get("code").toString();
        String businessCode=bizData.get("businessCode").toString();
        String msg=bizData.get("msg").toString().trim();
        log.info("msg={}",msg);
        if((code.equals("0") && businessCode.equals("0000"))|| msg.equals("订单已经提现签约过")||(code.equals("0") && businessCode.equals("0200"))){
            // 通过userid查看当前的提现记录是否生成放款loanid
            LoanApplicationHistory applicationHistory=new LoanApplicationHistory();
//            log.info("oneClickData.getUserId()={},quotaCredit.getProductType()={}",oneClickData.getUserId(),quotaCredit.getProductType());
            applicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId()), oneClickData.getBizType());
                 log.info("打印获取的放款单信息applicationHistory={}",applicationHistory);
            if(Objects.isNull(applicationHistory)){
                applicationHistory=verificationApplicationHistory(applicationHistory,Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType(),0);
            }else{
                log.info("打印放款id,applicationHistory.getId()={}",applicationHistory.getId());
            }
            return new Result(ApplicationStatus.SUCCESS,new OneClickOV(applicationHistory.getId().toString().trim(),LoanStatusEnum.APPLY_WITHDRAWDEPOSIT.getDesc(),CreditStatusEnum.CREDIT_SUCC.getDesc()));
        }else{
            return Result.buildFail(msg) ;
        }
    }


   public LoanApplicationHistory verificationApplicationHistory(LoanApplicationHistory applicationHistory,Long userId,Integer businessType,int num){
       if(Objects.isNull(applicationHistory)){
           applicationHistory = loanOperationService.selectLoanId(userId, businessType);
           if(num<50&& Objects.isNull(applicationHistory)){
               num++;
               verificationApplicationHistory(applicationHistory,userId, businessType,num);
           }else{
               log.info("打印一下最终的quotaCredit={}", applicationHistory);
           }
       }
       return applicationHistory;
   }

   /**
   * 掌众的申请提现
   * */
    public JSONObject applyZhangZhongLoan(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        String url = qapiHttp+"/ex/api/v2/withdraw/ZHANGZHONG";


        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        Map<String,String> paras = new HashMap<String, String>();

        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber",oneClickData.getPhone());

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}",paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);


        return result;
    }

}
