package cn.quantgroup.cashloanflowboss.core.persistence;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by WeiWei on 2017/6/13.
 */
@Data
@MappedSuperclass
public class Primary implements Serializable {


    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;

    @PrePersist
    public void prePersist() {
        Date data = new Date();
        createTime = data;
        updateTime = data;
    }

    @PreUpdate
    public void preUpdate() {
        updateTime = new Date();
    }

}
